﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using Mdws2ORM;
using System;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.WF
{
    public class ListPatientMovementIensCommand
    {
        public DateTime? StartTime { get; set; }
        public DateTime? EndTime { get; set; }
        public int? MaxCount { get; set; }        

        private static BmsLogger logger = new BmsLogger("Vista Integration: ListPatientMovementIensCommand:");        

        private IList<PatientMovementIen> NoResult()
        {
            return new PatientMovementIen[0];
        }

        public IList<PatientMovementIen> Execute(ISession session)
        {            
            if (!StartTime.HasValue || !EndTime.HasValue || StartTime.Value > EndTime.Value)
                return NoResult();

            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("B");            
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            List<PatientMovementIen> result = new List<PatientMovementIen>();
            string from = Converters.ToInternalFormat(StartTime.Value);

            foreach (string part in ParamUtilities.GetPartMonthBetweenDates(StartTime.Value, EndTime.Value))
            {
                builder.Partial(part);
                bool hasMore = true;
                while (hasMore)
                {
                    builder.From(from);
                    int size = result.Count;
                    result.AddRange(session.List<PatientMovementIen>(builder.Build()).Select(s => s.Entity));
                    int partialSize = result.Count - size;
                    logger.LogFormat(BmsLogger.Level.Info, "ListPatientMovementIensCommand: count - {0} month {1}", partialSize.ToString(), part);
                    hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;
                    if (hasMore)
                    {
                        DateTime lastDateTime = result.Last().MovementDate;
                        from = Converters.ToInternalFormat(lastDateTime.AddSeconds(-1));
                        while (result.Last().MovementDate == lastDateTime)
                            result.RemoveAt(result.Count - 1);
                    }
                }
                from = string.Empty;
            }
            List<PatientMovementIen> newResult = new List<PatientMovementIen>();
            if (result != null & result.Count > 0)
            {
                decimal transaction = 0;
                foreach (PatientMovementIen pm in result)
                {
                    decimal.TryParse(pm.TransactionTypeId, out transaction);
                    if ((transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MAX))
                        newResult.Add(pm);
                }
            }
            return newResult;

        }
    }
}
