﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.DataContracts;
using BMS.MT;
using ePractice.MiddleTier;
using BMS.Translators;
using System.ServiceModel;
using BMS.Utils;
using BMS.VistaIntegration.Audit.Properties;

namespace BMS.VistaIntegration.Audit
{
    public class AuditImplementation : IAudit
    {
        public AuditImplementation() { }

        public void AddLogEntry(JobLog logEntry)
        {
            if (logEntry == null)
                throw new ArgumentNullException("logEntry");

            JobAuditBO auditBO = (JobAuditBO)MTServices.Instance[Resources.MT_JobAudit].CreateNew();
            logEntry.CopyTo(auditBO);
            auditBO.Save();
            int id = auditBO.ID.Value;
            logEntry.Id = id;
        }

        public void UpdateLogEntry(JobLog logEntry)
        {
            if (logEntry == null)
                throw new ArgumentNullException("logEntry");

            JobAuditBO auditBO = (JobAuditBO)MTServices.Instance[Resources.MT_JobAudit].GetEntityByID(logEntry.Id);
            logEntry.CopyTo(auditBO);
            auditBO.Save();
        }
    }
}
