﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Web;
using System.IO;


namespace BMS.Utils
{
    public class Utilities
    {
        public static string GetBaseLanguage(string language)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (String.IsNullOrEmpty(language))
                    return null;

                int index = language.IndexOf('-');
                if (index >= 0)
                    return language.Substring(0, index);
                return language;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static Dictionary<string, string> SplitPersonFullName(string fullName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Dictionary<string, string> result = new Dictionary<string, string>();
                result.Add(Constants.PERSON_FIRST_NAME, string.Empty);
                result.Add(Constants.PERSON_MIDDLE_NAME, string.Empty);
                result.Add(Constants.PERSON_LAST_NAME, string.Empty);

                string firstName = string.Empty, lastName = string.Empty, middleName = string.Empty;

                fullName = fullName.Trim();

                try
                {
                    string[] names = fullName.Split(',');

                    lastName = names[0].Trim();
                    firstName = names[1].Trim();
                    names = firstName.Split(' ');
                    if (names.Length == 2)
                    {
                        firstName = names[0].Trim();
                        middleName = names[1].Trim();
                    }
                }
                catch
                {
                    lastName = fullName;
                    firstName = string.Empty;
                    middleName = string.Empty;
                }

                result[Constants.PERSON_FIRST_NAME] = firstName;
                result[Constants.PERSON_MIDDLE_NAME] = middleName;
                result[Constants.PERSON_LAST_NAME] = lastName;

                return result;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static string GenericToStringUsingPropertyReflection<T>(T instance, bool showNull = true)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Type type = typeof(T);
                return ObjectToStringUsingPropertyReflection(instance, type, showNull);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static string ObjectToStringUsingPropertyReflection(Object obj, bool showNull = true)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Type type = obj.GetType();
                return ObjectToStringUsingPropertyReflection(obj, type, showNull);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private static void AppendLine(StringBuilder sb, object result, string property, bool showNull)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (result == null)
                {
                    if (showNull)
                        sb.AppendLine(string.Format("{0} is null", property));
                }
                else
                {
                    sb.AppendLine(string.Format("{0}={1}", property, result));
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private static string ObjectToStringUsingPropertyReflection(Object obj, Type type, bool showNull)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                StringBuilder sb = new StringBuilder();
                // Get fields that are to be serialized.
                PropertyInfo[] properties = type.GetProperties();


                foreach (PropertyInfo p in properties)
                {
                    object result = p.GetValue(obj, null);
                    AppendLine(sb, result, p.Name, showNull);

                }

                FieldInfo[] fields = type.GetFields();

                foreach (FieldInfo field in fields)
                {
                    object result = field.GetValue(obj);
                    AppendLine(sb, result, field.Name, showNull);

                }


                return sb.ToString();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static bool IsIE7Browser()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                HttpBrowserCapabilities brObject = HttpContext.Current.Request.Browser;
                if (brObject.Browser.Equals("IE") && brObject.Version.StartsWith("7."))
                    return true;
                else
                    return false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void ClearEVSImages()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string path = HttpContext.Current.Server.MapPath("~/Content/images/EVS/");                
                if (Directory.Exists(path))
                {
                    foreach (string file in Directory.GetFiles(path))
                    {
                        try
                        {
                            File.Delete(file);
                        }
                        catch { }
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
