﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Utils
{
    /// <summary>
    /// Contract used as parameter for BMS filter methods 
    /// </summary>
    public class PagingContext
    {
        /// <summary>
        /// Gets or sets the page number.
        /// </summary>
        /// <value>
        /// The page number.
        /// </value>
        public int PageNumber { get; set; }

        /// <summary>
        /// Gets or sets the number of records per page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the order by column.
        /// </summary>
        /// <value>
        /// The order by.
        /// </value>
        public string OrderBy { get; set; }

    }
}
