﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Utils
{
    #region miscellaneous

    public enum MethodType
    {
        Create,
        Read,
        Update,
        Delete,
        Execute
    }

    /// <summary>
    /// Type of event
    /// </summary>
    public enum NewEvent
    {
        SignedAdmission,
        AdmittedPatient,
        SignedTransfer,
        SignedDischarge,
        SignedAnticipatedDischarge,
        DischargeAppointment,
        PatientDischarged,
        VacatedBed,
        CurrentlyCleaningBed,
        CompletedCleaningBed,
        BedOutOfService,
        BackToService
    }

    public enum ContactType
    {
        Mobile,
        Phone,
        Email,
        Fax,
        Another
    }

    #endregion

    #region VistaIntegration

    public enum DataRetrievalMethod { ODBC = 1, MDWS = 2 }
    public enum JobLaunchType { Automatic = 1, Manual }
    public enum JobStatus { Succeeded = 1, Failed = 2, Running = 4, PartiallySucceeded = 8 }
    public enum OccurrenceInterval { Day, Week, Month }
    public enum RunInterval { Hour, Minute }
    public enum TimePeriod { Today, LastWeek, LastMonth }
    public enum ActType { AdmissionOrder = 1, ScheduledAdmission = 1, MovementOrder, PatientAppointment, DischargeOrder, All }

    #endregion
}
