﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using InfoWorld.Security.Authorization.PolicyAdministrationPoint;
using BMS.ServicesWrapper.Proxy.PDP;

namespace BMS.ServicesWrapper.Security
{   
    /// <summary>
    /// PAP factory class responsible for PAP wrapper creation and proxy accessing.
    /// </summary>
    public class SecurityFactory
    {
        // Static constructor
        static SecurityFactory()
        {
            _instance = new SecurityWrapper(false);
            _instanceWindows = new SecurityWrapper(true);
        }

        /// <summary>
        /// The underlying IPAPWrapper instance as readonly.
        /// </summary>
        private static readonly ISecurityWrapper _instance;

        /// <summary>
        /// The underlying IPAPWrapper instance as readonly for Windows authentication.
        /// </summary>
        private static readonly ISecurityWrapper _instanceWindows;

        /// <summary>
        /// The PAPWrapper instance used by clients.
        /// </summary>
        public static ISecurityWrapper Instance
        {
            get { return SecurityFactory._instance; }
        }

        /// <summary>
        /// The PAPWrapper Windows instance used by clients.
        /// </summary>
        public static ISecurityWrapper InstanceWindows
        {
            get { return SecurityFactory._instanceWindows; }
        }

        /// <summary>
        /// Private instance used to access the internal methods.
        /// </summary>
        private static SecurityWrapper PAPWrapperInstance
        {
            get { return _instance as SecurityWrapper; }
        }

        /// <summary>
        /// Private Windows instance used to access the internal methods.
        /// </summary>
        private static SecurityWrapper PAPWrapperInstanceWindows
        {
            get { return _instanceWindows as SecurityWrapper; }
        }

        /// <summary>
        /// Access to the PAP AdministrativeFunctions WCF proxy.
        /// </summary>
        internal static AdministrativeFunctionsClient AdministrativeFunctionsClient
        {
            get { return ProxyManager.GetProxy<AdministrativeFunctionsClient>("PAP.AdministrativeFunctions"); }
        }

        /// <summary>
        /// Access to the PAP AdministrativeFunctions WCF proxy using Windows authentication.
        /// </summary>
        internal static AdministrativeFunctionsClient AdministrativeFunctionsClientWindows
        {
            get { return ProxyManager.GetProxy<AdministrativeFunctionsClient>("PAP.AdministrativeFunctions.Windows"); }
        }

        /// <summary>
        /// Access to the PDP AuthorizationService WCF proxy.
        /// </summary>
        internal static AuthorizationServiceClient AuthorizationServiceClient
        {
            get { return ProxyManager.GetProxy<AuthorizationServiceClient>("PDP.AuthorizationService"); }
        }

        /// <summary>
        /// Access to the PDP AuthorizationService WCF proxy using Windows authentication.
        /// </summary>
        internal static AuthorizationServiceClient AuthorizationServiceClientWindows
        {
            get { return ProxyManager.GetProxy<AuthorizationServiceClient>("PDP.AuthorizationService.Windows"); }
        }
 

    }

}
