﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FC = BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using BMS.FaultContracts;
using BMS.Facade.Fault;
using System.ServiceModel;
using BMS.Utils.Properties;

namespace BMS.ServicesWrapper.Proxy.WF
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Name = "BMS.Workflows.WF.IWaitingListFlow", ConfigurationName = "BMS.Workflows.WF.IWaitingListFlow")]
    public interface BMSWorkflowsWFIWaitingListFlow
    {
        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/CreateWaitingListItem", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/CreateWaitingListItemResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/CreateWaitingListItemGenericWFServiceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "pWaitingListItemId")]
        II CreateWaitingListItem(FC.WaitingListItem pWaitingListItem);

        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/ModifyWaitingListItem", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/ModifyWaitingListItemResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/ModifyWaitingListItemGenericWFServi" +
            "ceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        void ModifyWaitingListItem(FC.WaitingListItem pWaitingListItem);

        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/RemoveFromWaitingList", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/RemoveFromWaitingListResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.IWaitingListFlow/RemoveFromWaitingListGenericWFServic" +
            "eFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        void RemoveFromWaitingList(FC.WaitingListItem pWaitingListItem);
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface BMSWorkflowsWFIWaitingListFlowChannel : BMSWorkflowsWFIWaitingListFlow, System.ServiceModel.IClientChannel
    {
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BMSWorkflowsWFIWaitingListFlowClient : System.ServiceModel.ClientBase<BMSWorkflowsWFIWaitingListFlow>, BMSWorkflowsWFIWaitingListFlow, IDisposable
    {
        #region ProxyTool Generated Code

        private BMSWorkflowsWFIWaitingListFlowClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BMSWorkflowsWFIWaitingListFlowClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BMSWorkflowsWFIWaitingListFlowClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BMSWorkflowsWFIWaitingListFlowClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BMSWorkflowsWFIWaitingListFlowClient(_endpointConfigurationName);
                else
                    _instance = new BMSWorkflowsWFIWaitingListFlowClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIWaitingListFlow>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIWaitingListFlow>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIWaitingListFlow>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFIWaitingListFlow>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public BMSWorkflowsWFIWaitingListFlowClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIWaitingListFlowClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIWaitingListFlowClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIWaitingListFlowClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFIWaitingListFlowClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateWaitingListItem(FC.WaitingListItem pWaitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateWaitingListItem(pWaitingListItem);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateWaitingListItem(pWaitingListItem);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFIWaitingListFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void ModifyWaitingListItem(FC.WaitingListItem pWaitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.ModifyWaitingListItem(pWaitingListItem);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.ModifyWaitingListItem(pWaitingListItem);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFIWaitingListFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void RemoveFromWaitingList(FC.WaitingListItem pWaitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.RemoveFromWaitingList(pWaitingListItem);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.RemoveFromWaitingList(pWaitingListItem);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFIWaitingListFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UndoRemoveFromWaitingList(FC.WaitingListItem pWaitingListItem)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    pWaitingListItem.UndoRemovalOfPreviousItem = true;
                    _instance.Channel.CreateWaitingListItem(pWaitingListItem);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.CreateWaitingListItem(pWaitingListItem);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFIWaitingListFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
