using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using InfoWorld.EVS.CTSMAPI;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy.EVS.MAPI
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Namespace = "urn://hl7.org/CTSMAPI", ConfigurationName = "InfoWorld.EVS.CTSMAPI.RuntimeOperations")]
    public interface RuntimeOperations
    {

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/getSupportedMatchAlgorithms", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/getSupportedMatchAlgorithmsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedMatchAlgorithmsReturn")]
        ST[] getSupportedMatchAlgorithms();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/getSupportedVocabularyDomains", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/getSupportedVocabularyDomainsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownMatchAlgorithm), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(BadlyFormedMatchText), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "BadlyFormedMatchText")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedVocabularyDomainsReturn")]
        ST[] getSupportedVocabularyDomains(ST matchText, ST matchAlgorithm_code, int timeout, int sizeLimit);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/validateCode", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/validateCodeResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "validateCodeReturn")]
        ValidateCodeReturn validateCode(ST vocabularyDomain_name, CD codeToValidate, ST applicationContext_code, BL activeConceptsOnly, BL errorCheckOnly);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/validateTranslation", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/validateTranslationResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "validateTranslationReturn")]
        ValidateCodeReturn validateTranslation(ST vocabularyDomain_name, CD codeToValidate, ST applicationContext_code, BL activeConceptsOnly, BL errorCheckOnly);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/translateCode", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/translateCodeResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnableToTranslate), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnableToTranslate")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "translateCodeReturn")]
        CD translateCode(ST vocabularyDomain_name, CD fromCode, UID toCodeSystemId, ST toApplicationContext_code);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/fillInDetails", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/fillInDetailsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(NoApplicableDesignationFound), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableDesignationFound")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "fillInDetailsReturn")]
        CD fillInDetails(CD codeToFillIn, ST displayLanguage_code);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/subsumes", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/subsumesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(QualifiersNotSupported), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "QualifiersNotSupported")]
        [System.ServiceModel.FaultContractAttribute(typeof(SubsumptionNotSupported), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "SubsumptionNotSupported")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnrecognizedQualifier), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnrecognizedQualifier")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "subsumesReturn")]
        BL subsumes(CD parentCode, CD childCode);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/areEquivalent", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/areEquivalentResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnrecognizedQualifier), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnrecognizedQualifier")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(QualifiersNotSupported), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "QualifiersNotSupported")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(SubsumptionNotSupported), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "SubsumptionNotSupported")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "areEquivalentReturn")]
        BL areEquivalent(CD code1, CD code2);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExpansion", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExpansionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupValueSetExpansionReturn")]
        ValueSetExpansion[] lookupValueSetExpansion(ST vocabularyDomain_name, ST applicationContext_code, ST language_code, BL expandAll, int timeout, int sizeLimit);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSet", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "expandValueSet")]
        ValueSetExpansion[] expandValueSet(ST valueSet_ID, ST language_code, BL expandAll, int timeout, int sizeLimit);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetWithProperties", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetWithPropertiesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "expandValueSetWithProperties")]
        ListOfValueSetExpansionWithProperties expandValueSetWithProperties(ST valueSet_ID, ST language_code, BL expandAll, int timeout, int sizeLimit, ST[] properties);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetExpansionContext", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetExpansionContextResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InvalidExpansionContext), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "InvalidExpansionContext")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "expandValueSetExpansionContextReturn")]
        ValueSetExpansion[] expandValueSetExpansionContext(byte[] expansionContext);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/getServiceName", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/getServiceNameResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceNameReturn")]
        ST getServiceName();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/getServiceVersion", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/getServiceVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceVersionReturn")]
        ST getServiceVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/getServiceDescription", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/getServiceDescriptionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceDescriptionReturn")]
        ST getServiceDescription();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/getHL7ReleaseVersion", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/getHL7ReleaseVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getHL7ReleaseVersionReturn")]
        ST getHL7ReleaseVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/getCTSVersion", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/getCTSVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getCTSVersionReturn")]
        CTSVersionId getCTSVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/fillInDetailsExtended", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/fillInDetailsExtendedResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(NoApplicableDesignationFound), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableDesignationFound")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "fillInDetailsExtendedReturn")]
        Extended_CD fillInDetailsExtended(CD codeToFillIn, ST displayLanguage_code, BL qualifiers_only);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExpansionWPWithProperties", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExpansionWPWithPropertiesRe" +
            "sponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupValueSetExpansionWPWithProperties")]
        ValueSetExpansionPageWithProperties lookupValueSetExpansionWPWithProperties(ST vocabularyDomain_name, ST applicationContext_code, ST language_code, int timeout, int pageSize, ST[] properties);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetExpansionContextWPWithPrope" +
            "rties", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetExpansionContextWPWithPrope" +
            "rtiesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "expandValueSetExpansionContext_WPReturn")]
        ValueSetExpansionPageWithProperties expandValueSetExpansionContextWPWithProperties(byte[] pageExpansion, int pageSize, ST[] properties);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExpansionReverse", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExpansionReverseResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownValueSet")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownCodeSystem")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupValueSetExpansionReverseReturn")]
        ValueSetExpansion[] lookupValueSetExpansionReverse(ST valueSetId, ConceptId concept, ST language, int timeout);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExansion_WP", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/lookupValueSetExansion_WPResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguage), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownLanguage")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownVocabularyDomain), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownVocabularyDomain")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(NoApplicableValueSet), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "NoApplicableValueSet")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "expandValueSet_WPReturn")]
        ValueSetExpansionPage lookupValueSetExansion_WP(ST vocabularyDomain_name, ST applicationContext_code, ST language_code, int timeout, int pageSize);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetExpansionContext_WP", ReplyAction = "urn://hl7.org/CTSMAPI/RuntimeOperations/expandValueSetExpansionContext_WPResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownApplicationContextCode), Action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault", Name = "UnknownApplicationContextCode")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "expandValueSetExpansionContext_WPReturn")]
        ValueSetExpansionPage expandValueSetExpansionContext_WP(byte[] pageExpansion, int pageSize);
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface RuntimeOperationsChannel : RuntimeOperations, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class RuntimeOperationsClient : System.ServiceModel.ClientBase<RuntimeOperations>, RuntimeOperations, System.IDisposable
    {
        #region ProxyTool Generated Code

        private RuntimeOperationsClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;


        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new RuntimeOperationsClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new RuntimeOperationsClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new RuntimeOperationsClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new RuntimeOperationsClient(_endpointConfigurationName);
                else
                    _instance = new RuntimeOperationsClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<RuntimeOperations>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public RuntimeOperationsClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RuntimeOperationsClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ST[] getSupportedMatchAlgorithms()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedMatchAlgorithms();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedMatchAlgorithms();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ST[] getSupportedVocabularyDomains(ST matchText, ST matchAlgorithm_code, int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedVocabularyDomains(matchText, matchAlgorithm_code, timeout, sizeLimit);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedVocabularyDomains(matchText, matchAlgorithm_code, timeout, sizeLimit);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValidateCodeReturn validateCode(ST vocabularyDomain_name, CD codeToValidate, ST applicationContext_code, BL activeConceptsOnly, BL errorCheckOnly)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.validateCode(vocabularyDomain_name, codeToValidate, applicationContext_code, activeConceptsOnly, errorCheckOnly);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.validateCode(vocabularyDomain_name, codeToValidate, applicationContext_code, activeConceptsOnly, errorCheckOnly);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValidateCodeReturn validateTranslation(ST vocabularyDomain_name, CD codeToValidate, ST applicationContext_code, BL activeConceptsOnly, BL errorCheckOnly)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.validateTranslation(vocabularyDomain_name, codeToValidate, applicationContext_code, activeConceptsOnly, errorCheckOnly);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.validateTranslation(vocabularyDomain_name, codeToValidate, applicationContext_code, activeConceptsOnly, errorCheckOnly);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CD translateCode(ST vocabularyDomain_name, CD fromCode, UID toCodeSystemId, ST toApplicationContext_code)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.translateCode(vocabularyDomain_name, fromCode, toCodeSystemId, toApplicationContext_code);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.translateCode(vocabularyDomain_name, fromCode, toCodeSystemId, toApplicationContext_code);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CD fillInDetails(CD codeToFillIn, ST displayLanguage_code)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.fillInDetails(codeToFillIn, displayLanguage_code);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.fillInDetails(codeToFillIn, displayLanguage_code);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BL subsumes(CD parentCode, CD childCode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.subsumes(parentCode, childCode);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.subsumes(parentCode, childCode);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BL areEquivalent(CD code1, CD code2)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.areEquivalent(code1, code2);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.areEquivalent(code1, code2);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansion[] lookupValueSetExpansion(ST vocabularyDomain_name, ST applicationContext_code, ST language_code, BL expandAll, int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupValueSetExpansion(vocabularyDomain_name, applicationContext_code, language_code, expandAll, timeout, sizeLimit);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupValueSetExpansion(vocabularyDomain_name, applicationContext_code, language_code, expandAll, timeout, sizeLimit);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansion[] expandValueSet(ST valueSet_ID, ST language_code, BL expandAll, int timeout, int sizeLimit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.expandValueSet(valueSet_ID, language_code, expandAll, timeout, sizeLimit);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.expandValueSet(valueSet_ID, language_code, expandAll, timeout, sizeLimit);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ListOfValueSetExpansionWithProperties expandValueSetWithProperties(ST valueSet_ID, ST language_code, BL expandAll, int timeout, int sizeLimit, ST[] properties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.expandValueSetWithProperties(valueSet_ID, language_code, expandAll, timeout, sizeLimit, properties);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.expandValueSetWithProperties(valueSet_ID, language_code, expandAll, timeout, sizeLimit, properties);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansion[] expandValueSetExpansionContext(byte[] expansionContext)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.expandValueSetExpansionContext(expansionContext);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.expandValueSetExpansionContext(expansionContext);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ST getServiceName()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceName();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceName();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ST getServiceVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ST getServiceDescription()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceDescription();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceDescription();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ST getHL7ReleaseVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getHL7ReleaseVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getHL7ReleaseVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CTSVersionId getCTSVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getCTSVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getCTSVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public Extended_CD fillInDetailsExtended(CD codeToFillIn, ST displayLanguage_code, BL qualifiers_only)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.fillInDetailsExtended(codeToFillIn, displayLanguage_code, qualifiers_only);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.fillInDetailsExtended(codeToFillIn, displayLanguage_code, qualifiers_only);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansionPageWithProperties lookupValueSetExpansionWPWithProperties(ST vocabularyDomain_name, ST applicationContext_code, ST language_code, int timeout, int pageSize, ST[] properties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupValueSetExpansionWPWithProperties(vocabularyDomain_name, applicationContext_code, language_code, timeout, pageSize, properties);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupValueSetExpansionWPWithProperties(vocabularyDomain_name, applicationContext_code, language_code, timeout, pageSize, properties);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansionPageWithProperties expandValueSetExpansionContextWPWithProperties(byte[] pageExpansion, int pageSize, ST[] properties)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.expandValueSetExpansionContextWPWithProperties(pageExpansion, pageSize, properties);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.expandValueSetExpansionContextWPWithProperties(pageExpansion, pageSize, properties);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansion[] lookupValueSetExpansionReverse(ST valueSetId, ConceptId concept, ST language, int timeout)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupValueSetExpansionReverse(valueSetId, concept, language, timeout);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupValueSetExpansionReverse(valueSetId, concept, language, timeout);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansionPage lookupValueSetExansion_WP(ST vocabularyDomain_name, ST applicationContext_code, ST language_code, int timeout, int pageSize)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupValueSetExansion_WP(vocabularyDomain_name, applicationContext_code, language_code, timeout, pageSize);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupValueSetExansion_WP(vocabularyDomain_name, applicationContext_code, language_code, timeout, pageSize);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ValueSetExpansionPage expandValueSetExpansionContext_WP(byte[] pageExpansion, int pageSize)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.expandValueSetExpansionContext_WP(pageExpansion, pageSize);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.expandValueSetExpansionContext_WP(pageExpansion, pageSize);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<RuntimeOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
