﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using System.ServiceModel;
using BMS.FaultContracts;
using BMS.Facade.Fault;

namespace BMS.Workflows.CustomActivities.Utils
{
    public class HandleGenericServiceFault : CodeActivity
    {
        public InArgument<Exception> FaultData { get; set; }
        public OutArgument<FaultException<GenericWFServiceFault>> FaultResult { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Exception exception = this.FaultData.Get<Exception>(context);
                if ((exception as FaultException<ConfigValueException>) != null)
                {
                    FaultException<ConfigValueException> fault = exception as FaultException<ConfigValueException>;
                    this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    return;
                }
                if ((exception as FaultException<CustomSQLException>) != null)
                {
                    FaultException<CustomSQLException> fault = exception as FaultException<CustomSQLException>;
                    this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    return;
                }
                if ((exception as FaultException<DefaultConfigException>) != null)
                {
                    FaultException<DefaultConfigException> fault = exception as FaultException<DefaultConfigException>;
                    this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    return;
                }
                if ((exception as FaultException<EntityNotFoundException>) != null)
                {
                    FaultException<EntityNotFoundException> fault = exception as FaultException<EntityNotFoundException>;
                    this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    return;
                }
                if ((exception as FaultException<NullParameterException>) != null)
                {
                    FaultException<NullParameterException> fault = exception as FaultException<NullParameterException>;
                    this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    return;
                }
                if ((exception as FaultException<OtherException>) != null)
                {
                    FaultException<OtherException> fault = exception as FaultException<OtherException>;
                    this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = fault.Detail }));
                    return;
                }
                this.FaultResult.Set(context, new FaultException<GenericWFServiceFault>(new GenericWFServiceFault() { ServiceFault = exception }));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
