﻿using System;
using System.Activities;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Workflows.PropertyPromotionActivity
{
    public class PromoteValue<T> : CodeActivity
    {
        public PromoteValue()
        {
        }

        public bool ClearExistingPromotedData { get; set; }
        public string Name { get; set; }
        public InArgument<T> Value { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                PromotionPersistenceParticipant persistenceParticipant = context.GetExtension<PromotionPersistenceParticipant>();

                if (persistenceParticipant != null && this.Name != null && this.Value != null)
                {
                    if (this.ClearExistingPromotedData)
                    {
                        persistenceParticipant.ClearExistingPromotionData();
                    }

                    string propertyName = this.Name;
                    T propertyValue = context.GetValue<T>(this.Value);
                    persistenceParticipant.AddPromotedVariable(propertyName, propertyValue);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
