﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.EVS;
using BMS.VistaIntegration.Data;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.DalCached
{
    public abstract class BaseCachedDal<T> : IEntityDal<T>
        where T : class
    {
        public IEntityDal<T> Dal { get; private set; }

        public BaseCachedDal(IEntityDal<T> dal)
        {
            this.Dal = dal;
        }

        public VistaSite Site { get { return Dal.Site; } }

        private Dictionary<string, T> cache;

        public IEnumerable<T> Values
        {
            get
            {
                if (cache == null) cache = InitCache();
                return cache.Values;
            }
        }

        protected abstract Dictionary<string, T> InitCache();

        private T TryGet(string ien)
        {
            T value;            
            cache.TryGetValue(ien, out value);
            return value;
        }

        public virtual T Get(IEntity entity)
        {
            if (cache == null) cache = InitCache();
            return TryGet(entity.IEN);
        }


        public void Add(IEntity vistaEntity, T entity)
        {
            Dal.Add(vistaEntity, entity);
            if (cache != null) 
                cache.Add(vistaEntity.IEN, entity);
        }

        public void Delete(IEntity vistaEntity, T entity)
        {
            Dal.Delete(vistaEntity, entity);
            if (cache != null) 
                cache.Remove(vistaEntity.IEN);
        }

        public void Update(IEntity vistaEntity, T entity)
        {
            Dal.Update(vistaEntity, entity);
        }

        public static IEISWrapper EIS { get { return EISFactory.InstanceWindows; } }
        public static IEVSWrapper EVS { get { return EVSFactory.InstanceWindows; } }

    }
}
