﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EVS;
using BMS.ServicesWrapper.EIS;
using BMS.Utils;
using WfPatient = BMS.Facade.Data.Patient;
using SC = BMS.DataContracts;
using BMS.VistaWorker2.Writer.Implementation.Concrete.EIS;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.Facade;
using BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using FC = BMS.Facade.Data;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete
{
    /// <summary>
    /// Abstract base writer for workflow entities.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public abstract class BaseWorkFlowWriter<T> : BaseEntityWriter<T>
    {
        public override void InitCache()
        {
        }

        /// <summary>
        /// Sends the event.
        /// </summary>
        /// <param name="entity">The entity.</param>
        protected abstract bool SendEvent(T entity);

        protected override void OnInsert(T entity)
        {
            DoSendEvent(entity);
        }

        protected abstract VistaIntegrationLog MakeLog(T entity);

        protected virtual bool AlreadyProcessed(T entity)
        {
            return false;
        }

        private bool DoSendEvent(T entity)
        {
            if (LogChecker == null)
                return SendEvent(entity);

            VistaIntegrationLog log = MakeLog(entity);

            bool alreadyProcessed = IsAlreadyProcessed(log);
            if (alreadyProcessed)
            {
                bool result = AlreadyProcessed(entity);
                Logger.LogFormat(BmsLogger.Level.Info, "ADT item was already processed: Vista={0} Type={1} Ien={2}", VistaSite.Code, log.File, log.Ien);
                log = null;
                return result;
            }
            else
            {
                bool success = SendEvent(entity);
                if (success)
                    SaveVistaIntegration(log);
                log = null;
                return success;
            }
        }

        private bool IsAlreadyProcessed(VistaIntegrationLog log)
        {
            return LogChecker.Exists(log, VistaSite.Code);
        }

        private void SaveVistaIntegration(VistaIntegrationLog log)
        {
            BMSFactory.BedManagerOperationsClientWindows.SaveVistaIntegrationLog(log, VistaSite.Code);
        }

        protected override void OnDelete(T entity)
        {
            throw new InvalidOperationException();
        }

        protected override bool OnUpdate(T entity)
        {
            return DoSendEvent(entity);
        }


        /// <summary>
        /// Makes the wf patient.
        /// </summary>
        /// <param name="patient">The patient.</param>
        /// <returns></returns>
        protected WfPatient MakeWfPatient(BMS.VistaIntegration.Data.Patient entity)
        {
            return InsertIfNullOrUpdateIfDirty<BMS.VistaIntegration.Data.Patient, WfPatient>(entity);
        }

        protected Facade.Data.Person MakeWfPerson(BMS.VistaIntegration.Data.NewPerson entity)
        {
            return InsertIfNullOrUpdateIfDirty<BMS.VistaIntegration.Data.NewPerson, Facade.Data.Person>(entity);
        }        

        /// <summary>
        /// Makes the wf patient.
        /// </summary>
        /// <param name="patient">The patient.</param>
        /// <returns></returns>
        protected II MakePatient(BMS.VistaIntegration.Data.Patient entity)
        {
            if (entity == null || string.IsNullOrEmpty(entity.SocialSecurityNumber)) return null;
            WfPatient patient = MakeWfPatient(entity);
            if (patient != null)
                return patient.Id;
            return null;
        }

        /// <summary>
        /// Makes the wf person.
        /// </summary>
        /// <param name="person">The person.</param>
        /// <returns></returns>
        protected II MakePerson(BMS.VistaIntegration.Data.NewPerson entity)
        {
            if (entity == null) return null;
            Facade.Data.Person person = MakeWfPerson(entity);
            if (person != null)
                return person.Id;
            return null;
        }
    }
}
