﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using SC = BMS.DataContracts;
using FC = BMS.Facade.Data;
using BMS.ServicesWrapper.WF;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.VistaWorker.Exceptions;
using BMS.ServicesWrapper.BMService;

namespace BMS.VistaWorker.Writer.Concrete.WF
{
    /// <summary>
    /// The patient appointment writer.
    /// </summary>
    class PatientAppointmentWriter : BaseWorkFlowWriter<PatientAppointment>
    {
        /// <summary>
        /// Sends the event.
        /// </summary>
        /// <param name="entity">The entity.</param>
        protected override void SendEvent(PatientAppointment entity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string domainId = BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.GetCurrentDomain();
                FC.HospitalLocation hospitalLocation = EIS.GetHospitalLocation(entity.HospitalLocationId, VistaSite.Id);
                List<SC.HospitalLocationAppointment> hlList = BMSFactory.BedManagerOperationsClientWindows.GetHospitalLocationsAppointment(null, Guid.Parse(VistaSite.Id.extension));
                if (hlList.Where(a => a.HospitalLocationId.extension.Equals(hospitalLocation.Id.extension, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault() != null)
                {
                    SC.DischargeAppointment wfDischarge = new SC.DischargeAppointment()
                    {
                        Id = new II(domainId, null),                        
                        AppointmentDate = entity.AppointmentDateTime,
                        Status = entity.CurrentStatus,
                        EnteredDate = entity.DateAppointmentMade,                        
                        PatientId = MakeWfPatient(entity.Patient),
                        HospitalLocationId = (hospitalLocation != null) ? hospitalLocation.Id : null,
                        VistaSiteId = (VistaSite != null) ? VistaSite.Id : null
                    };
                    ConvertToUtc(wfDischarge);

                    try
                    {
                        BMS.ServicesWrapper.BMService.BMSFactory.BedManagerOperationsClientWindows.CreateDischargeAppointment(wfDischarge);
                        string msj = string.Format("Create discharge intent for patient {0} with succes", entity.Patient.Name);
                        Logger.LogInformation(msj);
                    }
                    catch (FaultException<GenericWFServiceFault> e)
                    {
                        string format = "Create discharge intent for patient {0} failed:\n{1}";
                        string msj = string.Format(format, entity.Patient.Name, e.Detail);
                        throw new AbortEntityProcessingException(msj);
                    }
                }
                else
                {
                    string msj = string.Format("Abort: Hospital Location {0} from PatientAppointment with id {1} has not been added from BMS in Bed Board Discharge Appointment Clinic Configuration"
                        , hospitalLocation.Name, entity.IEN);
                    throw new AbortEntityProcessingException(msj);
                }                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
