﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;
using BMS.Facade.Data;
using BMS.Utils;

namespace BMS.VistaWorker.Writer.Abstract
{
    /// <summary>
    /// Interface implemented by entity writer used to write changes for entity T to the data source.
    /// </summary>
    /// <typeparam name="T">The entity type.</typeparam>
    public interface IEntityWriter<T> where T : IEntity
    {

        /// <summary>
        /// Inits the data.
        /// </summary>
        /// <param name="vistaSite">The vista site.</param>
        /// <param name="vistATimeZone">The vist A time zone.</param>
        void InitData(VistaSite vistaSite, TimeZoneInfo vistATimeZone, BmsLogger logger);

        /// <summary>
        /// Inserts the specified entity.
        /// </summary>
        /// <param name="entity">The entity to insert.</param>
        /// <exception cref="WriterConnectionLostException">Connection to writer has been lost.</exception>
        void Insert(T entity);

        /// <summary>
        /// Updates the specified entity.
        /// </summary>
        /// <param name="entity">The entity to update.</param>
        /// <exception cref="WriterConnectionLostException">Connection to writer has been lost.</exception>
        void Update(T entity);

        /// <summary>
        /// Deletes the specified entity.
        /// </summary>
        /// <param name="entity">The entity to delete.</param>
        /// <exception cref="WriterConnectionLostException">Connection to writer has been lost.</exception>
        void Delete(T entity);
    }
}
