﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista room bed entity.
    /// </summary>
    [Serializable]
    public class RoomBed : IEntity 
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }
        /// <summary>
        /// Gets or sets a value indicating whether [currently out of service].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [currently out of service]; otherwise, <c>false</c>.
        /// </value>
        public bool CurrentlyOutOfService { get; set; }
        /// <summary>
        /// Gets or sets the ward location id ien.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public string WardLocationId { get; set; }
        /// <summary>
        /// Gets or sets the out of service date.
        /// </summary>
        /// <value>
        /// The out of service date.
        /// </value>
        public DateTime? OutOfServiceDate { get; set; }

        public IList<WardsWhichCanAssign> WardsWhichCanAssign { get; set; }

        public override string ToString()
        {
            return "RoomBed:" + Name;
        }



    }
}
