﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista patient entity.
    /// </summary>
    [Serializable]
    public class Patient : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        /// <value>
        /// The sex.
        /// </value>
        public char Sex { get; set; }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public int? WardLocationId { get; set; }

        /// <summary>
        /// Gets or sets the room bed id.
        /// </summary>
        /// <value>
        /// The room bed id.
        /// </value>
        public int? RoomBedId { get; set; }

        /// <summary>
        /// Gets or sets the name of the treating specialty.
        /// </summary>
        /// <value>
        /// The name of the treating specialty.
        /// </value>
        public string TreatingSpecialtyName { get; set; }

        /// <summary>
        /// Gets or sets the social security number.
        /// </summary>
        /// <value>
        /// The social security number.
        /// </value>
        public string SocialSecurityNumber { get; set; }

        /// <summary>
        /// Gets or sets the current movement id.
        /// </summary>
        /// <value>
        /// The current movement id.
        /// </value>
        public int? CurrentMovementId { get; set; }

        /// <summary>
        /// Gets or sets the current admission id.
        /// </summary>
        /// <value>
        /// The current admission id.
        /// </value>
        public int? CurrentAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the name of the marital status.
        /// </summary>
        /// <value>
        /// The name of the marital status.
        /// </value>
        public string MaritalStatusName { get; set; }

        /// <summary>
        /// Gets or sets the marital status id.
        /// </summary>
        /// <value>
        /// The marital status id.
        /// </value>
        public int? MaritalStatusId { get; set; }

        /// <summary>
        /// Gets or sets the name1 u4 N.
        /// </summary>
        /// <value>
        /// The name1 u4 N.
        /// </value>
        public string Name1U4N { get; set; }

        /// <summary>
        /// Gets or sets the treating specialty id.
        /// </summary>
        /// <value>
        /// The treating specialty id.
        /// </value>
        public int? TreatingSpecialtyId { get; set; }

        /// <summary>
        /// Gets or sets the admitting diagnosis.
        /// </summary>
        /// <value>
        /// The admitting diagnosis.
        /// </value>
        public string AdmittingDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the service connected percentage.
        /// </summary>
        /// <value>
        /// The service connected percentage.
        /// </value>
        public int? ServiceConnectedPercentage { get; set; }

        /// <summary>
        /// Gets or sets the attending physician.
        /// </summary>
        /// <value>
        /// The attending physician.
        /// </value>
        public int? AttendingPhysicianId { get; set; }

        /// <summary>
        /// Gets or sets the attending physician.
        /// </summary>
        /// <value>
        /// The attending physician.
        /// </value>
        public NewPerson AttendingPhysician { get; set; }

        public override string ToString()
        {
            return "Patient:" + Name;
        }
    }

}
