﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaWorker.Abstract
{
    /// <summary>
    /// The writer session implementation.
    /// </summary>
    internal class WriterSession : IWriterSession
    {
        private bool isOpen = false;
        private readonly IWriterManager writerManager;
        private readonly IReaderManager readerManager;

        /// <summary>
        /// Initializes a new instance of the <see cref="WriterSession"/> class.
        /// </summary>
        /// <param name="writerManager">The writer manager.</param>
        /// <param name="readerManager">The reader manager.</param>
        public WriterSession(IWriterManager writerManager, IReaderManager readerManager)
        {
            this.readerManager = readerManager;
            this.writerManager = writerManager;
        }

        /// <summary>
        /// Gets the entity processed.
        /// </summary>
        internal IEntity EntityProcessed { get; private set; }

        /// <summary>
        /// Inserts the entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        public void InsertEntity(IEntity entity)
        {
            EntityProcessed = entity;
            entity.Insert(writerManager);
            readerManager.ProcessingEntitySuccess(entity);

        }



        /// <summary>
        /// Updates the entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        public void UpdateEntity(IEntity entity)
        {
            EntityProcessed = entity;
            entity.Update(writerManager);
            readerManager.ProcessingEntitySuccess(entity);
        }


        /// <summary>
        /// Deletes the entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        public void DeleteEntity(IEntity entity)
        {
            EntityProcessed = entity;
            entity.Delete(writerManager);
            readerManager.ProcessingEntitySuccess(entity);
        }

        /// <summary>
        /// Opens writer session.
        /// </summary>
        /// <returns></returns>
        public IWriterSession Open()
        {
            if (isOpen) return this;
            isOpen = true;
            writerManager.Start();
            return this;
        }

        /// <summary>
        /// Closes writer session.
        /// </summary>
        public void Close()
        {
            if (!isOpen) return;
            isOpen = false;
            writerManager.Stop();
        }


    }
}
