﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaWorker.Abstract
{
    /// <summary>
    /// Interface implemented by writer session.
    /// </summary>
    public interface IWriterSession 
    {
        /// <summary>
        /// Opens writer session.
        /// </summary>
        /// <returns></returns>
        IWriterSession Open();

        /// <summary>
        /// Inserts the entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        void InsertEntity(IEntity entity);
        /// <summary>
        /// Updates the entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        void UpdateEntity(IEntity entity);
        /// <summary>
        /// Deletes the entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        void DeleteEntity(IEntity entity);

        /// <summary>
        /// Closes writer session.
        /// </summary>
        void Close();

    }
}
