﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;


namespace BMS.VistaWorker.Abstract
{
    /// <summary>
    /// Controller implementation.
    /// </summary>
    public class Controller : IController
    {
        public IWriterManager WriterManager { get; private set; }
        public IReaderManager ReaderManager { get; private set; }

        private bool _isDisposed = false;
        private bool _isStarted = false;

        /// <summary>
        /// Initializes a new instance of the <see cref="Controller"/> class.
        /// </summary>
        /// <param name="readerManager">Reader manager.</param>
        /// <param name="writerManager">Writer manager.</param>
        public Controller(IReaderManager readerManager, IWriterManager writerManager)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.ReaderManager = readerManager;
                this.WriterManager = new WriterManagerWrapper(writerManager);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        ///  Start the reader manager.
        /// </summary>
        public void Start()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (_isDisposed)
                    throw new InvalidOperationException("controller is disposed");
                if (_isStarted)
                    throw new InvalidOperationException("controller already started");

                _isStarted = true;
                ReaderManager.Start(this);
                //Logger.Log("Start");

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Stop the reader manager.
        /// </summary>
        public void Stop()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (_isDisposed)
                    throw new InvalidOperationException("controller is disposed");

                if (!_isStarted)
                    return;
                _isStarted = false;
                ReaderManager.Stop();
                //Logger.Log("Stop");

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (_isDisposed)
                    return;
                Stop();
                _isDisposed = true;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


    }
}
