﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaWorker.Reader.LinqToSql
{
    public static class Util
    {

        /// <summary>
        /// Bulk data processed callback.
        /// </summary>
        /// <param name="bulkSize">Size of the bulk.</param>
        /// <param name="finish">if set to <c>true</c> [finish].</param>
        public delegate void BulkProcessedCallback(int bulkSize, bool finish);


        /// <summary>
        /// Util function for processing data in bulks.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="bulkSize">Size of the bulk.</param>
        /// <param name="getDataFunc">The get data func.</param>
        /// <param name="bulkCallback">The bulk callback.</param>
        /// <returns></returns>
        public static IEnumerable<T> ProcessingBulkData<T>(int bulkSize, Func<IList<T>> getDataFunc, BulkProcessedCallback bulkCallback = null)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool hasMoreData;
                do
                {
                    IList<T> logEntities = getDataFunc();
                    foreach (var result in logEntities)
                        yield return result;
                    hasMoreData = logEntities.Count == bulkSize;
                    if (bulkCallback != null)
                        bulkCallback(logEntities.Count, !hasMoreData);
                } while (hasMoreData);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


    }
}
