﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Reader.Abstract
{
    public static class ILogDataExtensions
    {
        public static void ApplyChange(this ILogData data, IWriterManager writerManager)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                switch (data.CrudAction)
                {
                    case CrudAction.Insert:
                        writerManager.Insert(data.Entity);
                        return;
                    case CrudAction.Update:
                        writerManager.Update(data.Entity);
                        return;
                    case CrudAction.Delete:
                        writerManager.Delete(data.Entity);
                        return;

                    default:
                        throw new InvalidOperationException("No valid action on entity");

                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
