﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.VistaIntegration.Mdws2.Implementation.EIS;
using BMS.VistaIntegration.Mdws2.Implementation.EVS;
using BMS.VistaIntegration.Mdws2.Implementation.WF;
using BMS.VistaIntegration.Mdws2.Implementation;
using System.ServiceModel;
using BMS.VistaIntegration.VistA;
using BMS.Utils;
using BMS.VistaIntegration.Data.WF;

namespace BMS.VistaIntegration.Mdws2
{
    public class MdwsVistAQuery : IVistAQuery
    {
        private const int DEFAULT_BULK_COUNT = 1000;
        private readonly MdwsVistASession session;
        private readonly HospitalLocationCommand hospitalLocationCommand = new HospitalLocationCommand();
        private readonly PatientCommand patientCommand = new PatientCommand();
        private readonly RoomBedCommand roomBedCommand = new RoomBedCommand();
        private readonly WardLocationCommand wardLocationCommand = new WardLocationCommand();
        private readonly NewPersonCommand newPersonCommand = new NewPersonCommand();
        private readonly FacilityTreatingSpecialtyCommand facilityTreatingSpecialtyCommand = new FacilityTreatingSpecialtyCommand();
        private readonly FacilityMovementTypeCommand facilityMovementTypeCommand = new FacilityMovementTypeCommand();
        private readonly OrderableItemCommand orderableItemCommand = new OrderableItemCommand();
        private readonly SpecialtyCommand specialtyCommand = new SpecialtyCommand();
        private readonly OrderStatusCommand orderStatusCommand = new OrderStatusCommand();
        private readonly OrderActionCommand orderActionCommand = new OrderActionCommand();
        private readonly PatientMovementCommand patientMovementCommand = new PatientMovementCommand();
        private readonly ScheduledAdmissionCommand scheduledAdmissionCommand = new ScheduledAdmissionCommand();
        private readonly MedicalCenterDivisionCommand medicalCenterDivisionCommand = new MedicalCenterDivisionCommand();
        //private readonly CombinePatientAppointmentCommand patientAppointmentCommand = new CombinePatientAppointmentCommand();
        private readonly SinglePatientAppointmentCommand singlePatientAppointmentCommand = new SinglePatientAppointmentCommand();
        private readonly PatientAppointmentCommand patientAppointmentCommand = new PatientAppointmentCommand();

        public MdwsVistAQuery(MdwsVistASession session)
        {
            BulkCount = DEFAULT_BULK_COUNT;
            this.session = session;
        }

        public int BulkCount
        {
            get;
            set;
        }

        private IList<T> GetResult<T>(BaseCommand<T> command, DateTime? startDate = null, DateTime? endDate = null)
            where T : class , new()
        {
            if (!command.HasMore)
                return null;
            command.MaxCount = BulkCount;
            command.FromIenParam = command.LastIen;
            command.StartDate = startDate;
            command.EndDate = endDate;
            IList<T> result = null;
            session.RunClientAction(client => result = command.Execute(client));
            return result;
        }

        public IList<HospitalLocation> GetHospitalLocations()
        {
            return GetResult(hospitalLocationCommand);
        }

        public IList<Patient> GetPatients(DateTime? startDate = null, DateTime? endDate = null)
        {
            return GetResult(patientCommand, startDate, endDate);
        }

        public IList<RoomBed> GetRoomBeds()
        {
            return GetResult(roomBedCommand);
        }

        public IList<WardLocation> GetWardLocations()
        {
            return GetResult(wardLocationCommand);
        }

        public IList<NewPerson> GetNewPersons(DateTime? startDate = null, DateTime? endDate = null)
        {
            return GetResult(newPersonCommand, startDate, endDate);
        }

        public IList<FacilityTreatingSpecialty> GetFacilityTreatingSpecialties()
        {
            return GetResult(facilityTreatingSpecialtyCommand);
        }

        public IList<FacilityMovementType> GetFacilityMovementTypes()
        {
            return GetResult(facilityMovementTypeCommand);
        }

        public IList<OrderableItem> GetOrderableItems()
        {
            return GetResult(orderableItemCommand);
        }

        public IList<Specialty> GetSpecialties()
        {
            return GetResult(specialtyCommand);
        }

        public IList<OrderStatus> GetOrderStatuses()
        {
            return GetResult(orderStatusCommand);
        }

        public IList<OrderAction> GetOrderActions(DateTime? startDate = null, DateTime? endDate = null, string patientIen = null, IEnumerable<string> orderableItemsIen = null)
        {
            orderActionCommand.PatientIen = patientIen;
            orderActionCommand.OrderableItemsIen = orderableItemsIen;
            return GetResult(orderActionCommand, startDate, endDate);
        }

        //public IList<PatientAppointment> GetPatientAppointments(DateTime? startDate = null, DateTime? endDate = null, string patientIen = null, IEnumerable<string> clinicIens = null)
        //{
        //    if (!patientAppointmentCommand.HasMore) return null;
        //    patientAppointmentCommand.StartDate = startDate;
        //    patientAppointmentCommand.EndDate = endDate;
        //    patientAppointmentCommand.PatientIen = patientIen;
        //    patientAppointmentCommand.ClinicIens = clinicIens;
        //    IList<PatientAppointment> result = null;
        //    session.RunClientAction(client => result = patientAppointmentCommand.Execute(client));
        //    return result;
        //}

        public IList<PatientAppointment> GetPatientAppointments(DateTime? startDate = null, DateTime? endDate = null, string patientIen = null, IEnumerable<string> clinicIens = null)
        {
            if (string.IsNullOrEmpty(patientIen))
            {
                patientAppointmentCommand.ClinicIens = clinicIens;
                return GetResult(patientAppointmentCommand, startDate, endDate);
            }
            else
            {
                if (!singlePatientAppointmentCommand.HasMore)
                    return null;
                singlePatientAppointmentCommand.ClinicIens = clinicIens;
                singlePatientAppointmentCommand.PatientIen = patientIen;
                singlePatientAppointmentCommand.StartDate = startDate;
                singlePatientAppointmentCommand.EndDate = endDate;
                IList<PatientAppointment> result = null;
                session.RunClientAction(client => result = singlePatientAppointmentCommand.Execute(client));
                return result;
            }
        }

        public IList<PatientMovement> GetPatientMovements(DateTime? startDate = null, DateTime? endDate = null)
        {

            return GetResult(patientMovementCommand, startDate, endDate);

        }

        public IList<ScheduledAdmission> GetScheduledAdmissions(DateTime? startDate = null, DateTime? endDate = null, string patientIen = null)
        {
            scheduledAdmissionCommand.PatientIen = patientIen;
            return GetResult(scheduledAdmissionCommand, startDate, endDate);

        }

        public IList<MedicalCenterDivision> GetMedicalCenterDivisions()
        {
            return GetResult(medicalCenterDivisionCommand);
        }

        public Patient GetPatientByIen(string ien)
        {
            SinglePatientCommand singlePatientCommand = new SinglePatientCommand();
            Patient result = null;
            singlePatientCommand.PatientIen = ien;
            session.RunClientAction(client => result = singlePatientCommand.Execute(client));
            return result;
        }

        public PatientMovement GetPatientMovement(string patientIen, DateTime dateTime, MovementTransactionType movementType)
        {
            SinglePatientMovementCommand singlePatientMovementCommand = new SinglePatientMovementCommand();
            PatientMovement result = null;
            singlePatientMovementCommand.PatientIen = patientIen;
            singlePatientMovementCommand.DateTime = dateTime;
            singlePatientMovementCommand.MovementType = movementType;
            session.RunClientAction(client => result = singlePatientMovementCommand.Execute(client));
            return result;
        }

        public IList<BedSwitch> GetBedsSwitch(IEnumerable<string> iens)
        {
            BedSwitchCommand bedSwitchCommand = new BedSwitchCommand();
            IList<BedSwitch> result = null;
            bedSwitchCommand.PatientMovementsIEn = iens;
            session.RunClientAction(client => result = bedSwitchCommand.Execute(client));
            return result;
        }
    }
}
