﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.EIS;

namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class ScheduledAdmissionMap : FileMap<ScheduledAdmission>
    {
        private static readonly ScheduledAdmissionMap instance = new ScheduledAdmissionMap();
        public static ScheduledAdmissionMap Instance = new ScheduledAdmissionMap();

        private ScheduledAdmissionMap() { }

        public override string FileNumber
        {
            get { return "41.1"; }
        }

        protected override void Map()
        {
            MapIen((m, s) => m.IEN = s);
            Map((m, s) => m.PatientId = s, ".01");
            Map((m, s) => m.ReservationDateTime = s.VistAToDateTime(), "2");
            Map((m, s) => m.LengthOfStayExpected = int.Parse(s), "3");
            Map((m, s) => m.AdmittingDiagnosis = s, "4");
            Map((m, s) => m.ProviderId = s, "5");
            Map((m, s) => m.Surgery = s, "6");
            Map((m, s) => m.WardLocationId = s, "8");
            Map((m, s) => m.TreatingSpecialtyId = s, "9");
            Map((m, s) => m.SchedulerId = s, "11");
            Map((m, s) => m.MedicalCenterDivisionId = s, "12");
            Map((m, s) => m.DateTimeCancelled = s.VistAToDateTime(), "13");
            Map((m, s) => m.CancelledById = s, "14");
            MapReference((m, s) => m.Patient = s, PatientMap.Instance, ".01");

        }
    }
}
