﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.WF;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    public class SinglePatientMovementCommand
    {
        public DateTime DateTime { get; set; }
        public string PatientIen { get; set; }
        public MovementTransactionType MovementType { get; set; }

        public PatientMovement Execute(QuerySvcSoap client)
        {
            var query = PatientMovementMap.Instance.MakeQuery();
            query.Client = client;
            query.ScreenParam = string.Format(ScreenFormat, DateTime.VistAToInternalFormat(), (int)MovementType, PatientIen);
            query.IndexParam = "B";
            query.FromParam = DateTime.AddSeconds(-1).VistAToInternalFormat();
            query.BulkCount = 1;
            var result = query.GetResult();
            return result.SingleOrDefault();
        }

        private const string ScreenFormat = "I ($P(^(0),U,1)={0})&($P(^(0),U,2)={1})&($P(^(0),U,3)={2})";

    }
}
