﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.VistaIntegration.Mdws2.Maps;

namespace BMS.VistaIntegration.Mdws2.Implementation
{
    public abstract class BasePeriodCommand<T> : BaseCommand<T>
        where T : class , new()
    {
        protected abstract string FieldLocation { get; }

        private readonly string[] splitFieldsLocation;

        public BasePeriodCommand(IFileMap<T> fileMap)
            : base(fileMap)
        {
            splitFieldsLocation = FieldLocation.Split(';');
        }


        private const string StartDateScreen = "I $P(^({0}),U,{1})>={2}";
        private const string EndDateScreen = "I $P(^({0}),U,{1})<{2}";
        private const string StartEndDateScreen = "S x=$P(^({0}),U,{1})  I (x>={2})&(x<{3})";

        protected override string GetScreenParam()
        {
            if (StartDate.HasValue && EndDate.HasValue)
                return string.Format(StartEndDateScreen, splitFieldsLocation[0], splitFieldsLocation[1], StartDate.Value.VistAToInternalFormat(), EndDate.Value.VistAToInternalFormat());

            if (StartDate.HasValue)
                return string.Format(StartDateScreen, splitFieldsLocation[0], splitFieldsLocation[1], StartDate.Value.VistAToInternalFormat());

            if (EndDate.HasValue)
                return string.Format(EndDateScreen, splitFieldsLocation[0], splitFieldsLocation[1], EndDate.Value.VistAToInternalFormat());

            return string.Empty;
        }


    }
}
