﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    public abstract class SubFileMap<T, S> : IFileMap<S>
        where T : class , new()
        where S : class , new()
    {
        public FileMap<T> FileMap { get; private set; }

        protected SubFileMap(FileMap<T> fileMap)
        {
            this.FileMap = fileMap;
            Map();
        }

        private Dictionary<string, Action<S, string>> fieldsDictionary = new Dictionary<string, Action<S, string>>();
        private Dictionary<string, IReferenceFetch<S>> referencesDictionary = new Dictionary<string, IReferenceFetch<S>>();

        public abstract string SubFileNumber { get; }
        public abstract string FieldIenForSubFile { get; }
        public abstract string FirstFieldIenForSubFile { get; }
        public string FlagsParam { get { return FileMap.FlagsParam; } }

        public void Map(Action<S, string> setter, string fieldIen)
        {
            if (fieldsDictionary.ContainsKey(fieldIen))
                throw new InvalidOperationException();
            fieldsDictionary[fieldIen] = setter;

        }

        public abstract S MakeSubFile(T file);

        public void SetSubFileField(S entity, string fieldIen, string value)
        {
            Action<S, string> action = null;
            if (fieldsDictionary.TryGetValue(fieldIen, out action))
                action(entity, value);
        }

        public void MapReference<R>(Action<S, R> func, FileMap<R> fileMap, string fieldIen) where R : class , new()
        {

            ReferenceFetch<S, R> referenceFetch = new ReferenceFetch<S, R>(func, fileMap);
            if (referencesDictionary.ContainsKey(fieldIen))
                throw new InvalidOperationException();
            referencesDictionary[fieldIen] = referenceFetch;
        }

        public void MapTypeReference<R>(Action<S, R> func, FileMap<R> fileMap, string fieldIen, string type) where R : class , new()
        {

            ReferenceFetch<S, R> referenceFetch = new ReferenceFetch<S, R>(func, fileMap);
            IReferenceFetch<S> fetch = null;
            if (!referencesDictionary.TryGetValue(fieldIen, out fetch))
            {
                fetch = new TypeReferenceFetch<S>();
                referencesDictionary[fieldIen] = fetch;
            };

            TypeReferenceFetch<S> typeReferenceFetch = fetch as TypeReferenceFetch<S>;
            if (typeReferenceFetch == null)
                throw new InvalidOperationException();
            typeReferenceFetch.Add(type, referenceFetch);
        }

        public IReferenceFetch<S> GetReference(string fieldIen)
        {

            IReferenceFetch<S> referenceFetch = null;
            referencesDictionary.TryGetValue(fieldIen, out referenceFetch);
            return referenceFetch;

        }

        public string FieldsParam { get { return FileMap.FieldsParam; } }
        public string FileNumber { get { return FileMap.FileNumber; } }

        private string multipleFieldsParam;

        public string MultipleFieldsParam
        {
            get
            {
                if (multipleFieldsParam == null)
                    multipleFieldsParam = GetMultipleFieldsParam();
                return multipleFieldsParam;
            }
        }

        private string GetMultipleFieldsParam()
        {
            return FileMap.MultipleFieldsParam + FieldIenForSubFile + "*;";
        }

        public int FieldsCount { get { return FileMap.FieldsCount; } }

        protected abstract void Map();



        public IVistAQuery<S> MakeQuery()
        {
            return new SubFileFetch<T, S>(this);
        }
    }
}
