﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Linq.Expressions;
using System.Reflection;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    public abstract class FileMap<T> : IFileMap<T> where T : class , new()
    {
        private struct MapItem
        {
            public MapItem(string fieldIen, Action<T, string> action, bool listFetch)
            {
                FieldIen = fieldIen;
                Action = action;
                ListFetch = listFetch;
            }
            public readonly Action<T, string> Action;
            public readonly string FieldIen;
            public readonly bool ListFetch;
        }

        private Dictionary<string, MapItem> fieldsDictionary = new Dictionary<string, MapItem>();
        private Action<T, string> ienField;
        private Dictionary<string, Dictionary<string, MapItem>> multiplesDictionary = new Dictionary<string, Dictionary<string, MapItem>>();
        private Dictionary<string, string> multiplesFieldsDictionary = new Dictionary<string, string>();
        private Dictionary<string, IReferenceFetch<T>> referencesDictionary = new Dictionary<string, IReferenceFetch<T>>();
        public abstract String FileNumber { get; }


        private string InitFieldsParam(IEnumerable<MapItem> values)
        {
            StringBuilder fieldsParamBuilder = new StringBuilder("@;");
            foreach (MapItem s in values)
            {
                fieldsParamBuilder.Append(s.FieldIen);
                fieldsParamBuilder.Append(";");
            }
            return fieldsParamBuilder.ToString();
        }



        private void InitMultipleFieldsParam()
        {
            StringBuilder multipleFieldsBuilder = new StringBuilder();
            foreach (string s in multiplesFieldsDictionary.Keys)
            {
                multipleFieldsBuilder.Append(s);
                multipleFieldsBuilder.Append("*;");
            }
            MultipleFieldsParam = multipleFieldsBuilder.ToString();
        }


        protected FileMap()
        {
            FlagsParam = "IQ";
            Map();
            FieldsParam = InitFieldsParam(fieldsDictionary.Values.Where(m => m.ListFetch));
            GetFieldsParam = InitFieldsParam(fieldsDictionary.Values.Where(m => !m.ListFetch));
            InitMultipleFieldsParam();
        }


        public string FlagsParam { get; protected set; }

        public void Map(Action<T, string> setter, string fieldIen, bool getFetch = false)
        {
            string key = GetFieldIenKey(fieldIen);
            if (fieldsDictionary.ContainsKey(key))
                throw new InvalidOperationException();
            fieldsDictionary[key] = new MapItem(fieldIen, setter, !getFetch);
            if (!getFetch) FieldsCount++;
        }



        private string GetFieldIenKey(string fieldIen)
        {
            return fieldIen.TrimEnd('E', 'I');
        }

        public void MapIen(Action<T, string> setter)
        {

            if (ienField != null)
                throw new InvalidOperationException();
            ienField = setter;

        }

        public void MapMultiple(string fieldIen, string subFileNumber)
        {

            if (multiplesFieldsDictionary.ContainsKey(fieldIen))
                throw new InvalidOperationException();
            multiplesFieldsDictionary[fieldIen] = subFileNumber;
            multiplesDictionary[subFileNumber] = new Dictionary<string, MapItem>();
        }

        public void Map(Action<T, string> setter, string subFileNumber, string fieldIen)
        {
            if (multiplesDictionary[subFileNumber].ContainsKey(fieldIen))
                throw new InvalidOperationException();
            string key = GetFieldIenKey(fieldIen);
            multiplesDictionary[subFileNumber][key] = new MapItem(fieldIen, setter, true);
        }




        public void SetIen(T entity, string value)
        {
            ienField(entity, value);
        }

        public void SetField(T entity, string fieldIen, string value)
        {
            fieldsDictionary[fieldIen].Action(entity, value);
        }

        public void SetMultipleField(T entity, string subFileNumber, string fieldIen, string value)
        {
            MapItem item;
            if (multiplesDictionary[subFileNumber].TryGetValue(fieldIen, out item))
                item.Action(entity, value);
        }

        public virtual T Make()
        {
            return new T();
        }


        public void MapReference<R>(Action<T, R> func, FileMap<R> fileMap, string fieldIen) where R : class , new()
        {
            ReferenceFetch<T, R> referenceFetch = new ReferenceFetch<T, R>(func, fileMap);
            if (referencesDictionary.ContainsKey(fieldIen))
                throw new InvalidOperationException();
            referencesDictionary[fieldIen] = referenceFetch;
        }

        public void MapTypeReference<R>(Action<T, R> func, FileMap<R> fileMap, string fieldIen, string type) where R : class , new()
        {
            ReferenceFetch<T, R> referenceFetch = new ReferenceFetch<T, R>(func, fileMap);
            IReferenceFetch<T> fetch = null;
            if (!referencesDictionary.TryGetValue(fieldIen, out fetch))
            {
                fetch = new TypeReferenceFetch<T>();
                referencesDictionary[fieldIen] = fetch;
            };

            TypeReferenceFetch<T> typeReferenceFetch = fetch as TypeReferenceFetch<T>;
            if (typeReferenceFetch == null)
                throw new InvalidOperationException();
            typeReferenceFetch.Add(type, referenceFetch);
        }



        public string FieldsParam { get; private set; }
        public string MultipleFieldsParam { get; private set; }
        public string GetFieldsParam { get; private set; }
        public int FieldsCount { get; private set; }

        public IReferenceFetch<T> GetReference(string fieldIen)
        {

            IReferenceFetch<T> referenceFetch = null;
            referencesDictionary.TryGetValue(fieldIen, out referenceFetch);
            return referenceFetch;
        }

        protected abstract void Map();

        public IVistAQuery<T> MakeQuery()
        {
            return new FileFetch<T>(this);
        }
    }
}
