﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA patient appointment contract.
    /// </summary>
    [Serializable]
    public class PatientAppointment
    {

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>

        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        /// <value>
        /// The appointment date.
        /// </value>

        public DateTime AppointmentDateTime { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>

        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the date appointment made.
        /// </summary>
        /// <value>
        /// The date appointment made.
        /// </value>

        public DateTime? DateAppointmentMade { get; set; }


        /// <summary>
        /// Gets or sets the data entry clerk id.
        /// </summary>
        /// <value>
        /// The data entry clerk id.
        /// </value>

        public string DataEntryClerkId { get; set; }

        /// <summary>
        /// Gets or sets the current status.
        /// </summary>
        /// <value>
        /// The current status.
        /// </value>

        public string CurrentStatus { get; set; }

        /// <summary>
        /// Gets or sets the hospital location id.
        /// </summary>
        /// <value>
        /// The hospital location id.
        /// </value>

        public string HospitalLocationId { get; set; }

        public Patient Patient { get; set; }

        public string TelephoneOfClinic { get; set; }

        public HospitalLocation HospitalLocation { get; set; }

        public override string ToString()
        {
            string patient = Patient != null ? Patient.Name : "NULL";
            return string.Format("PatientAppointment {0} for patient {1}", AppointmentDateTime, patient);
        }
    }
}
