﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA patient contract.
    /// </summary>
    [Serializable]
    public class Patient : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>

        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>

        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        /// <value>
        /// The sex.
        /// </value>

        public char? Sex { get; set; }

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>

        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the social security number.
        /// </summary>
        /// <value>
        /// The social security number.
        /// </value>

        public string SocialSecurityNumber { get; set; }

        /// <summary>
        /// Gets or sets the name1 u4 N.
        /// </summary>
        /// <value>
        /// The name1 u4 N.
        /// </value>
        public string Name1U4N { get; set; }

        /// <summary>
        /// Gets or sets the treating specialty id.
        /// </summary>
        /// <value>
        /// The treating specialty id.
        /// </value>
        public string TreatingSpecialtyId { get; set; }

        /// <summary>
        /// Gets or sets the admitting diagnosis.
        /// </summary>
        /// <value>
        /// The admitting diagnosis.
        /// </value>
        public string AdmittingDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the service connected percentage.
        /// </summary>
        /// <value>
        /// The service connected percentage.
        /// </value>
        public int? ServiceConnectedPercentage { get; set; }

        /// <summary>
        /// Gets or sets the treating specialty.
        /// </summary>
        /// <value>
        /// The treating specialty.
        /// </value>
        public FacilityTreatingSpecialty TreatingSpecialty { get; set; }

        /// <summary>
        /// Gets or sets the attending physician.
        /// </summary>
        /// <value>
        /// The attending physician.
        /// </value>
        public NewPerson AttendingPhysician { get; set; }

        /// <summary>
        /// Gets or sets the date entered into file.
        /// </summary>
        /// <value>
        /// The date entered into file.
        /// </value>
        public DateTime? DateEnteredIntoFile { get; set; }

        /// <summary>
        /// Gets or sets the admission ien.
        /// </summary>
        /// <value>
        /// The admission ien.
        /// </value>
        public string AdmissionIen { get; set; }

        public override string ToString()
        {
            return "Patient:" + Name;
        }
    }
}
