﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA hospital location contract.
    /// </summary>
    [Serializable]       
    public class HospitalLocation : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>        
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>        
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the abbreviation.
        /// </summary>
        /// <value>
        /// The abbreviation.
        /// </value>        
        public string Abbreviation { get; set; }

        /// <summary>
        /// Gets or sets the telephone.
        /// </summary>
        /// <value>
        /// The telephone.
        /// </value>        
        public string Telephone { get; set; }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public string WardLocationId { get; set; }

        /// <summary>
        /// Gets or sets the ward location.
        /// </summary>
        /// <value>
        /// The ward location.
        /// </value>
        public WardLocation WardLocation { get; set; }

        public override string ToString()
        {
            return "HospitalLocation:" + Name;
        }
    }
}
