﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.ServiceContracts
{
    [ServiceContract]
    public interface ICacheService
    {
        #region EIS

        [OperationContract]
        void CacheEisEntity(string entityType, II id);

        [OperationContract]
        void RemoveCacheEisEntity(string entityType, II id);

        #endregion

        #region EVS

        [OperationContract]
        void CacheCD(string vocabularyDomain, string code);

        [OperationContract]
        void RemoveCacheCD(string vocabularyDomain, string code);

        #endregion

        #region Security

        [OperationContract]
        void ClearUserPermissionCache(string userName);

        [OperationContract]
        void CachePoliciesForOrganizations();

        [OperationContract]
        void CacheUserRoles(InfoWorld.Security.Authorization.PolicyAdministrationPoint.User user);

        #endregion

        [OperationContract]
        void RefreshCache();
    }
}
