﻿using System.Runtime.Serialization;
using System;
namespace BMS.FaultContracts
{    
    /// <summary>
    /// Fault contract for incorrect configuration values.
    /// </summary>
    [DataContract]
    public class ConfigValueException
    { 
        /// <summary>
        /// Gets or sets the key of the configuration.
        /// </summary>
        /// <value>
        /// The key.
        /// </value>
        [DataMember]
        public string Key { get; set; }
     
        /// <summary>
        /// Gets or sets the user name for which the configuration is defined.
        /// </summary>
        /// <value>
        /// The user name.
        /// </value>
        [DataMember]
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the configuration section.
        /// </summary>
        /// <value>
        /// The section.
        /// </value>
        [DataMember]
        public string Section { get; set; }

        /// <summary>
        /// Gets or sets the exception message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        [DataMember]
        public string Message { get; set; }
        /// <summary>
        /// Override ToString().
        /// </summary>
        /// <returns>Friendly print of the exception.</returns>
        public override string ToString()
        {
            return Message
                + (String.IsNullOrEmpty(UserName) ? String.Empty : "  UserName = " + UserName)
                + (String.IsNullOrEmpty(Key) ? String.Empty : "  Key = " + Key)
                + (String.IsNullOrEmpty(Section) ? String.Empty : "  Section = " + Section)
                ;
        }
    }
}
