﻿using System;
using System.Runtime.Serialization;
using System.Xml.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Data about a patient waiting used in filtering BMS operations.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "PatientWaitingStandardView")]
    [DataContract(Name = "PatientWaitingStandardView")]
    [KnownType(typeof(Act))]
    [KnownType(typeof(TransferInfo))]
    public class PatientWaitingStandardView : TransferInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the region code.
        /// </summary>
        /// <value>
        /// The region code.
        /// </value>
        [XmlElementAttribute("RegionCode", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "RegionCode", Order = 1)]
        public string RegionCode { get; set; }

        /// <summary>
        /// Gets or sets the VISN code.
        /// </summary>
        /// <value>
        /// The VISN code.
        /// </value>
        [XmlElementAttribute("VISNCode", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "VISNCode", Order = 2)]
        public string VISNCode { get; set; }

        /// <summary>
        /// Gets or sets the event date.
        /// </summary>
        /// <value>
        /// The event date.
        /// </value>
        [XmlElementAttribute("EventDate", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "EventDate", Order = 3)]
        public DateTime? EventDate { get; set; }

        #endregion
    }
}
