﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about where the patient is admitted.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "PatientLocation")]
    [DataContract(Name = "PatientLocation")]
    [KnownType(typeof(II))]
    public class PatientLocation
    {
        /// <summary>
        /// Gets or sets the current admission ward.
        /// </summary>
        /// <value>
        /// The current admission ward.
        /// </value>
        [XmlElementAttribute("CurrentAdmissionWardId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "CurrentAdmissionWardId", Order = 1)]
        public II CurrentAdmissionWardId { get; set; }

        /// <summary>
        /// Gets or sets the current admission bed.
        /// </summary>
        /// <value>
        /// The current admission bed.
        /// </value>
        [XmlElementAttribute("CurrentAdmissionBedId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "CurrentAdmissionBedId", Order = 2)]
        public II CurrentAdmissionBedId { get; set; }
    }
}
