﻿using System;
using InfoWorld.HL7.ITS;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using System.Collections.Generic;

namespace BMS.DataContracts
{
    /// <summary>
    /// Main entity for all orders.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "Order")]
    [DataContract(Name = "Order")]
    [KnownType(typeof(II))]
    public class Order
    {
        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the patient id on which the medical order is performed.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 2)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        [XmlElementAttribute("Ien", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Ien", Order = 3)]
        public string Ien { get; set; }

        /// <summary>
        /// Gets or sets the ordered date.
        /// </summary>
        /// <value>
        /// The ordered date.
        /// </value>
        [XmlElementAttribute("OrderedDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "OrderedDate", Order = 4)]
        public DateTime OrderedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the order is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if the order is active; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsActive", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "IsActive", Order = 5)]
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets the person id who signed the order document(EIS person).
        /// </summary>
        /// <value>
        /// The person id that signed the order.
        /// </value>
        [XmlElementAttribute("SignedById", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "SignedById", Order = 6)]
        public II SignedById { get; set; }        

        /// <summary>
        /// Gets or sets the date when the order document was signed.
        /// </summary>
        /// <value>
        /// The signed date.
        /// </value>
        [XmlElementAttribute("SignedDate", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "SignedDate", Order = 7)]
        public DateTime? SignedDate { get; set; }

        /// <summary>
        /// Gets or sets the release date of the order document.
        /// </summary>
        /// <value>
        /// The released date.
        /// </value>
        [XmlElementAttribute("ReleasedDate", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "ReleasedDate", Order = 8)]
        public DateTime? ReleasedDate { get; set; }

        /// <summary>
        /// Gets or sets the medical person id in charge with the order(EIS person reference).
        /// </summary>
        /// <value>
        /// The provider id.
        /// </value>
        [XmlElementAttribute("ProviderId", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "ProviderId", Order = 9)]
        public II ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the vista site id where the order was created.
        /// </summary>
        /// <value>
        /// The vista site id.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 10)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets the hospital location id where the order was created.
        /// </summary>
        /// <value>
        /// The hospital location id.
        /// </value>
        [XmlElementAttribute("HospitalLocationId", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "HospitalLocationId", Order = 11)]
        public II HospitalLocationId { get; set; }

        /// <summary>
        /// Gets or sets the ward id where the order was created.
        /// </summary>
        /// <value>
        /// The ward id.
        /// </value>
        [XmlElementAttribute("WardId", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 12)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the order text(details about the admission).
        /// </summary>
        /// <value>
        /// The order text.
        /// </value>
        [XmlElementAttribute("OrderText", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "OrderText", Order = 13)]
        public string OrderText { get; set; }

        /// <summary>
        /// Gets or sets the facility list for the order.
        /// </summary>
        /// <value>
        /// The facility list.
        /// </value>
        [XmlElementAttribute("FacilityList", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityList", Order = 14)]
        public List<II> FacilityList { get; set; }
    }
}
