﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contract used for logging in the BMS DB the users logged in in the application.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "LoggedUser")]
    [DataContract(Name = "LoggedUser")]
    [KnownType(typeof(II))]
    public class LoggedUser
    {
        /// <summary>
        /// Gets or sets the session id.
        /// </summary>
        /// <value>
        /// The session id.
        /// </value>
        [XmlElementAttribute("SessionId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "SessionId", Order = 1)]
        public string SessionId { get; set; }

        /// <summary>
        /// Gets or sets the name of the user.
        /// </summary>
        /// <value>
        /// The name of the user.
        /// </value>
        [XmlElementAttribute("UserName", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "UserName", Order = 2)]
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 3)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the visn.
        /// </summary>
        /// <value>
        /// The visn.
        /// </value>
        [XmlElementAttribute("VisnId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "VisnId", Order = 4)]
        public II VisnId { get; set; }
    }
}
