﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Icon Info class used for listing icons
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "IconInfo")]
    [DataContract(Name = "IconInfo")]    
    public class IconInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the icon id.
        /// </summary>
        /// <value>
        /// The icon id.
        /// </value>
        [XmlElementAttribute("IconId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "IconId", Order = 1)]
        public int IconId { get; set; }

        /// <summary>
        /// Gets or sets the group.
        /// </summary>
        /// <value>
        /// The group.
        /// </value>
        [XmlElementAttribute("Group", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "Group", Order = 2)]
        public string Group { get; set; }

        /// <summary>
        /// Gets or sets the subgroup.
        /// </summary>
        /// <value>
        /// The subgroup.
        /// </value>
        [XmlElementAttribute("Subgroup", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Subgroup", Order = 3)]
        public string Subgroup { get; set; }

        /// <summary>
        /// Gets or sets the image bytes.
        /// </summary>
        /// <value>
        /// The image bytes.
        /// </value>
        [XmlElementAttribute("ImageBytes", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "ImageBytes", Order = 4)]
        public string ImageBytes { get; set; }

        /// <summary>
        /// Gets or sets the image bytes inactive.
        /// </summary>
        /// <value>
        /// The image bytes inactive.
        /// </value>
        [XmlElementAttribute("ImageBytesInactive", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "ImageBytesInactive", Order = 5)]
        public string ImageBytesInactive { get; set; }

        /// <summary>
        /// Gets or sets the icon description.
        /// </summary>
        /// <value>
        /// The icon description.
        /// </value>
        [XmlElementAttribute("IconDescription", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "IconDescription", Order = 6)]
        public string IconDescription { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="IconInfo"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("Active", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "Active", Order = 7)]
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the index of the order.
        /// </summary>
        /// <value>
        /// The index of the order.
        /// </value>
        [XmlElementAttribute("OrderIndex", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "OrderIndex", Order = 8)]
        public int OrderIndex { get; set; }

        /// <summary>
        /// Gets or sets the patient or room bed.
        /// </summary>
        /// <value>
        /// The patient or room bed.
        /// </value>
        [XmlElementAttribute("PatientOrRoomBed", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "PatientOrRoomBed", Order = 9)]
        public char? PatientOrRoomBed { get; set; }

        /// <summary>
        /// Gets or sets the name of the icon.
        /// </summary>
        /// <value>
        /// The name of the icon.
        /// </value>
        [XmlElementAttribute("IconName", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "IconName", Order = 10)]
        public string IconName { get; set; }

        /// <summary>
        /// Gets or sets the mouse over text.
        /// </summary>
        /// <value>
        /// The mouse over text.
        /// </value>
        [XmlElementAttribute("MouseOverText", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "MouseOverText", Order = 11)]
        public string MouseOverText { get; set; }

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 12)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is association.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is association; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsAssociation", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "IsAssociation", Order = 13)]
        public bool IsAssociation { get; set; }

        /// <summary>
        /// Gets or sets the type of the icon.
        /// </summary>
        /// <value>
        /// The type of the icon.
        /// </value>
        [XmlElementAttribute("IconType", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "IconType", Order = 14)]
        public CD IconType { get; set; }

        /// <summary>
        /// Gets or sets the published.
        /// </summary>
        /// <value>
        /// The published.
        /// </value>
        [XmlElementAttribute("Published", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "Published", Order = 15)]
        public bool? Published { get; set; }

        /// <summary>
        /// Gets or sets the name of the image.
        /// </summary>
        /// <value>
        /// The name of the image.
        /// </value>
        [XmlElementAttribute("ImageName", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "ImageName", Order = 16)]
        public string ImageName { get; set; }

        #endregion
    }
}
