﻿using System;
using InfoWorld.HL7.ITS;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about diversions entries within BMS. 
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "Diversion")]
    [DataContract(Name = "Diversion")]
    [KnownType(typeof(II))]
    public class Diversion
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the facility to which this diversion applies.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 2)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets active. Whether the diversion is active (current) or not.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        [XmlElementAttribute("Active", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Active", Order = 3)]
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the start date the diversion is valid.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        [XmlElementAttribute("StartDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "StartDate", Order = 4)]
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date till the diversion is valid.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        [XmlElementAttribute("EndDate", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "EndDate", Order = 5)]
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the location to which the diversion applies.
        /// </summary>
        /// <value>
        /// The location.
        /// </value>
        [XmlElementAttribute("Location", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "Location", Order = 6)]
        public CD Location { get; set; }

        /// <summary>
        /// Gets or sets the additional diversion comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        [XmlElementAttribute("Comments", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "Comments", Order = 7)]
        public string Comments { get; set; }

		/// <summary>
		/// Gets or sets the user name of BMS application who entered a diversion.
		/// </summary>
		/// <value>
		/// The entered by.
		/// </value>
		[XmlElementAttribute("EnteredBy", Order = 8)]
		[DataMember(EmitDefaultValue = false, Name = "EnteredBy", Order = 8)]
		public string EnteredBy { get; set; }

		/// <summary>
		/// Gets or sets the entered date of a diversion.
		/// </summary>
		/// <value>
		/// The entered date.
		/// </value>
		[XmlElementAttribute("EnteredDate", Order = 9)]
		[DataMember(EmitDefaultValue = false, Name = "EnteredDate", Order = 9)]
		public DateTime EnteredDate { get; set; }

		/// <summary>
		/// Gets or sets the the user name of BMS application who changed a diversion.
		/// </summary>
		/// <value>
		/// The last edit by.
		/// </value>
		[XmlElementAttribute("LastEditBy", Order = 10)]
		[DataMember(EmitDefaultValue = false, Name = "LastEditBy", Order = 10)]
		public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 11)]
        public II VistaSiteId { get; set; }

        #endregion
    }
}