﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about discharge acts operated in BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "DischargeEvent")]
    [DataContract(Name = "DischargeEvent")]
    [KnownType(typeof(Event))]
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    public class DischargeEvent : Event
    {                
        /// <summary>
        /// Gets or sets the date when the discharge was made.
        /// </summary>
        /// <value>
        /// The discharged date.
        /// </value>
        [XmlElementAttribute("DischargedDate", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "DischargedDate", Order = 1)]
        public DateTime? DischargedDate { get; set; }

        /// <summary>
        /// Gets or sets the person who made the discharge.
        /// </summary>
        /// <value>
        /// The entered by id.
        /// </value>
        [XmlElementAttribute("EnteredById", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredById", Order = 2)]
        public II EnteredById { get; set; }

        /// <summary>
        /// Gets or sets the type of the movement(VistA related).
        /// </summary>
        /// <value>
        /// The type of the movement.
        /// </value>
        [XmlElementAttribute("MovementType", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "MovementType", Order = 3)]
        public CD MovementType { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        /// <value>
        /// The admission id.
        /// </value>
        [XmlElementAttribute("AdmissionId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionId", Order = 4)]
        public II AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the admission ien.
        /// </summary>
        /// <value>
        /// The admission ien.
        /// </value>
        [XmlElementAttribute("AdmissionIen", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionIen", Order = 5)]
        public string AdmissionIen { get; set; }
    }
}
