﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Collections;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Filtering class for bed cleaning. Contains data for quering existing bed that needs to be cleaned.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedCleanInfo")]
    [DataContract(Name = "BedCleanInfo")]    
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    public class BedCleanInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [XmlElementAttribute("BedId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 1)]
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        [XmlElementAttribute("WardId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 2)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the manual request.
        /// </summary>
        /// <value>
        /// The manual request.
        /// </value>
        [XmlElementAttribute("ManualRequest", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "ManualRequest", Order = 3)]
        public CD ManualRequest { get; set; }

        /// <summary>
        /// Gets or sets the vacated date.
        /// </summary>
        /// <value>
        /// The vacated date.
        /// </value>
        [XmlElementAttribute("VacatedDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "VacatedDate", Order = 4)]
        public DateTime? VacatedDate { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        [XmlElementAttribute("RequestedDate", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedDate", Order = 5)]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the accepted by.
        /// </summary>
        /// <value>
        /// The accepted by.
        /// </value>
        [XmlElementAttribute("AcceptedBy", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "AcceptedBy", Order = 6)]
        public string AcceptedBy { get; set; }

        /// <summary>
        /// Gets or sets the accepted date.
        /// </summary>
        /// <value>
        /// The accepted date.
        /// </value>
        [XmlElementAttribute("AcceptedDate", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "AcceptedDate", Order = 7)]
        public DateTime? AcceptedDate { get; set; }

        /// <summary>
        /// Gets or sets the completed by.
        /// </summary>
        /// <value>
        /// The completed by.
        /// </value>
        [XmlElementAttribute("CompletedBy", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "CompletedBy", Order = 8)]
        public string CompletedBy { get; set; }

        /// <summary>
        /// Gets or sets the completed date.
        /// </summary>
        /// <value>
        /// The completed date.
        /// </value>
        [XmlElementAttribute("CompletedDate", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "CompletedDate", Order = 9)]
        public DateTime? CompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the last edited by.
        /// </summary>
        /// <value>
        /// The last edited by.
        /// </value>
        [XmlElementAttribute("LastEditedBy", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditedBy", Order = 10)]
        public string LastEditedBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit date.
        /// </summary>
        /// <value>
        /// The last edit date.
        /// </value>
        [XmlElementAttribute("LastEditDate", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditDate", Order = 11)]
        public DateTime? LastEditDate { get; set; }

        /// <summary>
        /// Gets or sets the type of the unavailable.
        /// </summary>
        /// <value>
        /// The type of the unavailable.
        /// </value>
        [XmlElementAttribute("UnavailableType", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "UnavailableType", Order = 12)]
        public CD UnavailableType { get; set; }

        /// <summary>
        /// Gets or sets EMS Notify flag.
        /// </summary>
        /// <value>
        /// The EMS notified flag.
        /// </value>
        [XmlElementAttribute("EMSNotify", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "EMSNotify", Order = 13)]
        public string EMSNotify { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [XmlElementAttribute("Comment", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "Comment", Order = 14)]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the user who added, modified a comment.
        /// </summary>
        /// <value>
        /// The user who added, modified a comment.
        /// </value>
        [XmlElementAttribute("CommentedBy", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "CommentedBy", Order = 15)]
        public string CommentedBy { get; set; }

        /// <summary>
        /// Gets or sets the date when the comment was added,modified.
        /// </summary>
        /// <value>
        /// The date when the comment was added,modified.
        /// </value>
        [XmlElementAttribute("CommentedDate", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "CommentedDate", Order = 16)]
        public DateTime? CommentedDate { get; set; }

        /// <summary>
        /// Gets or sets the event ien.
        /// </summary>
        /// <value>
        /// The event ien.
        /// </value>
        [XmlElementAttribute("EventIen", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "EventIen", Order = 17)]
        public string EventIen { get; set; }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 18)]
        public II Id { get; set; }

        #endregion
    }
}
