﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.DataContracts;
using BMS.MT;
using BMS.Utils;

namespace BMS.ServiceImplementation.Utils
{
    public static class TranslatorAudit
    {
        public static void CopyTo(this JobAuditBO auditBO, JobLogInfo audit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                audit.EndDate = auditBO.END_DATE.Value;
                audit.ErrorMessage = auditBO.ERROR_MESSAGE.Value;
                audit.LaunchType = (JobLaunchType)auditBO.LAUNCH_TYPE.Value;
                audit.RetrievalMethod = (DataRetrievalMethod)auditBO.RETRIEVAL_METHOD.Value;
                audit.RetrievedDataType = (VistaDataType)auditBO.RETRIEVED_DATA_TYPE.Value;
                audit.RetrievedEntriesNumber = auditBO.RETRIEVED_ENTRIES_NUMBER.Value;
                audit.StartDate = auditBO.START_DATE.Value;
                audit.Status = (JobStatus)auditBO.STATUS.Value;
                audit.VistaId = auditBO.VISTA_ID.Value;
                audit.VistaName = auditBO.VISTA_NAME.Value;
                audit.Details = auditBO.DETAILS.Value;

                if (auditBO.JOB_AUDIT_PARAMS != null)
                {
                    foreach (JobAuditParamBO parameter in auditBO.JOB_AUDIT_PARAMS)
                    {
                        if (parameter.NAME.Value != null && parameter.NAME.Value.Equals(Constants.JOB_AUDIT_QUERY_START_DATE))
                            audit.QueryStartDate = DateTime.Parse(parameter.VALUE.Value);
                        if (parameter.NAME.Value != null && parameter.NAME.Value.Equals(Constants.JOB_AUDIT_QUERY_END_DATE))
                            audit.QueryEndDate = DateTime.Parse(parameter.VALUE.Value);
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        public static void CopyTo(this JobLogInfo audit, JobAuditBO auditBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                auditBO.END_DATE.Value = audit.EndDate;
                auditBO.ERROR_MESSAGE.Value = audit.ErrorMessage;
                auditBO.LAUNCH_TYPE.Value = (byte)audit.LaunchType;
                auditBO.RETRIEVAL_METHOD.Value = (byte)audit.RetrievalMethod;
                auditBO.RETRIEVED_DATA_TYPE.Value = (short)audit.RetrievedDataType;
                auditBO.RETRIEVED_ENTRIES_NUMBER.Value = audit.RetrievedEntriesNumber;
                auditBO.START_DATE.Value = audit.StartDate;
                auditBO.STATUS.Value = (byte)audit.Status;
                auditBO.VISTA_ID.Value = audit.VistaId;
                auditBO.VISTA_NAME.Value = audit.VistaName;
                auditBO.DETAILS.Value = audit.Details;

                if (audit.QueryStartDate.HasValue)
                {
                    JobAuditParamBO oldBO = auditBO.JOB_AUDIT_PARAMS.FirstOrDefault(p => p.NAME.Value == Constants.JOB_AUDIT_QUERY_START_DATE);
                    if (oldBO == null)
                        oldBO = auditBO.JOB_AUDIT_PARAMS.AddNew();
                    oldBO.NAME.Value = Constants.JOB_AUDIT_QUERY_START_DATE;
                    oldBO.VALUE.Value = audit.QueryStartDate.Value.ToUniversalTime().ToString();
                }
                if (audit.QueryEndDate.HasValue)
                {
                    JobAuditParamBO oldBO = auditBO.JOB_AUDIT_PARAMS.FirstOrDefault(p => p.NAME.Value == Constants.JOB_AUDIT_QUERY_END_DATE);
                    if (oldBO == null)
                        oldBO = auditBO.JOB_AUDIT_PARAMS.AddNew();
                    oldBO.NAME.Value = Constants.JOB_AUDIT_QUERY_END_DATE;
                    oldBO.VALUE.Value = audit.QueryEndDate.Value.ToUniversalTime().ToString();
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
