﻿using BMS.MT;
using System;
using BMS.Utils;

namespace BMS.Translators
{
    public static class TranslatorTransferInfo
    {
        public static void CopyTo(this TransferInfoBO transferInfoBO, DataContracts.TransferInfo transferInfo)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                transferInfo.CanceledDate = transferInfoBO.CANCELED_DATE.Value;
                transferInfo.CreationDate = transferInfoBO.CREATION_DATE.Value;
                transferInfo.Id = TranslatorUtils.BuildIdentifier(transferInfoBO.DOMAIN_ID, transferInfoBO.ACT_ID);
                transferInfo.Parent = TranslatorUtils.BuildParentAct(TranslatorUtils.BuildIdentifier(transferInfoBO.DOMAIN_ID, transferInfoBO.PARENT_ACT_ID));
                transferInfo.PatientId = TranslatorUtils.BuildIdentifier(transferInfoBO.DOMAIN_ID, transferInfoBO.PATIENT_UID);
                transferInfo.FlowId = transferInfoBO.FLOW_ID.Value;
                transferInfo.Era = TranslatorUtils.BuildConcept(transferInfoBO.REQ_ERA_CODE, transferInfoBO.REQ_ERA_CODE_SYSTEM, transferInfoBO.REQ_ERA_CODE_SYSTEM_NAME, transferInfoBO.REQ_ERA_DISPLAY_NAME);
                transferInfo.AdmissionFacilityId = TranslatorUtils.BuildIdentifier(transferInfoBO.DOMAIN_ID, transferInfoBO.EVN_ADMISSION_FACILITY_UID);
                transferInfo.FacilityId = TranslatorUtils.BuildIdentifier(transferInfoBO.DOMAIN_ID, transferInfoBO.REQ_FACILITY_UID);
                transferInfo.Contract = TranslatorUtils.BuildConcept(transferInfoBO.REQ_CONTRACT_CODE, transferInfoBO.REQ_CONTRACT_CODE_SYSTEM, transferInfoBO.REQ_CONTRACT_CODE_SYSTEM_NAME, transferInfoBO.REQ_CONTRACT_DISPLAY_NAME);
                transferInfo.Diagnosis = transferInfoBO.REQ_DIAGNOSIS.Value;
                transferInfo.CurrentLocation = transferInfoBO.REQ_CURRENT_LOCATION.Value;
                transferInfo.Speciality = TranslatorUtils.BuildConcept(transferInfoBO.REQ_SPECIALITY_CODE, transferInfoBO.REQ_SPECIALITY_CODE_SYSTEM, transferInfoBO.REQ_SPECIALITY_CODE_SYSTEM_NAME, transferInfoBO.REQ_SPECIALITY_DISPLAY_NAME);
                transferInfo.Comment = transferInfoBO.REQ_COMMENTS.Value;
                transferInfo.DispositionDate = transferInfoBO.EVN_DISPOSITION_DATE.Value;
                transferInfo.LocationAdmissionDate = transferInfoBO.REQ_LOCATION_ADMISSION_DATE.Value;
                transferInfo.FacilityVISN = transferInfoBO.REQ_FACILITY_VISN.Value;
                transferInfo.IsNationalWaitList = transferInfoBO.IS_NATIONAL_WAIT_LIST.Value == true ? true : false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
