﻿using BMS.MT;
using System;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorSpecialtyTransfer
    {
        public static void CopyTo(this SpecialtyTransferBO specialtyTransferBO, DataContracts.SpecialtyTransfer specialtyTransfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                specialtyTransfer.Id = TranslatorUtils.BuildIdentifier(specialtyTransferBO.DOMAIN_ID, specialtyTransferBO.ID);
                specialtyTransfer.Ien = specialtyTransferBO.IEN.Value;
                specialtyTransfer.PatientId = TranslatorUtils.BuildIdentifier(specialtyTransferBO.DOMAIN_ID, specialtyTransferBO.PATIENT_UID);
                specialtyTransfer.VistaSiteId = TranslatorUtils.BuildIdentifier(specialtyTransferBO.DOMAIN_ID, specialtyTransferBO.VISTA_SITE_UID);
                specialtyTransfer.DateTime = specialtyTransferBO.DATE_TIME.Value;
                specialtyTransfer.TypeOfMovement = TranslatorUtils.BuildConcept(specialtyTransferBO.TYPE_OF_MOVEMENT_CODE, specialtyTransferBO.TYPE_OF_MOVEMENT_CODE_SYSTEM, specialtyTransferBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME, specialtyTransferBO.TYPE_OF_MOVEMENT_DISPLAY_NAME);
                specialtyTransfer.EnteredDate = specialtyTransferBO.ENTERED_DATE.Value;
                specialtyTransfer.EnteredById = TranslatorUtils.BuildIdentifier(specialtyTransferBO.DOMAIN_ID, specialtyTransferBO.ENTERED_BY_UID);
                specialtyTransfer.AdmissionId = TranslatorUtils.BuildIdentifier(specialtyTransferBO.DOMAIN_ID, specialtyTransferBO.ADMISSION_ID);
                specialtyTransfer.AdmissionIen = specialtyTransferBO.ADMISSION_IEN.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.SpecialtyTransfer specialtyTransfer, SpecialtyTransferBO specialtyTransferBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {                
                if (specialtyTransfer.Id != null)
                {
                    specialtyTransferBO.DOMAIN_ID.Value = specialtyTransfer.Id.root;
                    int? id = specialtyTransfer.Id.extension.ParseAsInt();
                    if (id.HasValue)
                        specialtyTransferBO.ID.Value = id.Value;
                }
                specialtyTransferBO.IEN.Value = specialtyTransfer.Ien;
                if (specialtyTransfer.PatientId != null)                                 
                    specialtyTransferBO.PATIENT_UID.Value = Guid.Parse(specialtyTransfer.PatientId.extension);
                        
                if (specialtyTransfer.VistaSiteId != null)
                    specialtyTransferBO.VISTA_SITE_UID.Value = Guid.Parse(specialtyTransfer.VistaSiteId.extension);                
                specialtyTransferBO.DATE_TIME.Value = specialtyTransfer.DateTime;
                if (specialtyTransfer.TypeOfMovement != null)
                {
                    specialtyTransferBO.TYPE_OF_MOVEMENT_CODE.Value = specialtyTransfer.TypeOfMovement.code;
                    specialtyTransferBO.TYPE_OF_MOVEMENT_CODE_SYSTEM.Value = specialtyTransfer.TypeOfMovement.codeSystem;
                    specialtyTransferBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME.Value = specialtyTransfer.TypeOfMovement.codeSystemName;
                    specialtyTransferBO.TYPE_OF_MOVEMENT_DISPLAY_NAME.Value = specialtyTransfer.TypeOfMovement.displayName;
                }
                specialtyTransferBO.ENTERED_DATE.Value = specialtyTransfer.EnteredDate;
                if (specialtyTransfer.EnteredById != null)
                    specialtyTransferBO.ENTERED_BY_UID.Value = Guid.Parse(specialtyTransfer.EnteredById.extension);
                specialtyTransferBO.ADMISSION_IEN.Value = specialtyTransfer.AdmissionIen;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
