﻿using BMS.MT;
using System;
using BMS.Utils;
using System.Collections.Generic;
using BMS.DataContracts;
using System.Linq;
using System.ServiceModel;

namespace BMS.Translators
{
    public static class TranslatorPatientsWaitingCount
    {
        public static void CopyTo(this PatientsWaitingCountBO patientsWaitingCountBO, DataContracts.PatientWaitingCount patientsWaitingCount)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                patientsWaitingCount.WaitingListCount = patientsWaitingCountBO.WAITING_LIST_COUNT.Value.Value;
                patientsWaitingCount.ScheduledAdmissionsCount = patientsWaitingCountBO.SCHEDULED_ADMISSIONS_COUNT.Value.Value;                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
