﻿using System;
using BMS.MT;

namespace BMS.Translators
{
    public static class TranslatorIconAssociationInfo
    {
        public static void CopyTo(this IconAssociationInfoBO iconInfoBO, DataContracts.IconAssociationInfo iconInfo)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                iconInfo.IconId = (iconInfoBO.ICON_ID.Value.HasValue) ? iconInfoBO.ICON_ID.Value.Value : -1;
                iconInfo.Group = iconInfoBO.GROUP.Value;
                iconInfo.Subgroup = iconInfoBO.SUBGROUP.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
