﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;

namespace BMS.Translators
{
    public static class TranslatorEvacuationPatient
    {
        public static void CopyTo(this EvacuationPatientsBO evacuationPatientBO, DataContracts.EvacuationPatient evacuationPatient)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                evacuationPatient.CanceledDate = evacuationPatientBO.CANCELED_DATE.Value;
                evacuationPatient.CreationDate = evacuationPatientBO.CREATION_DATE.Value;
                evacuationPatient.Id = TranslatorUtils.BuildIdentifier(evacuationPatientBO.DOMAIN_ID, evacuationPatientBO.ACT_ID);
                evacuationPatient.Parent = TranslatorUtils.BuildParentAct(TranslatorUtils.BuildIdentifier(evacuationPatientBO.DOMAIN_ID, evacuationPatientBO.PARENT_ACT_ID));
                evacuationPatient.PatientId = TranslatorUtils.BuildIdentifier(evacuationPatientBO.DOMAIN_ID, evacuationPatientBO.PATIENT_UID);
                evacuationPatient.FlowId = evacuationPatientBO.FLOW_ID.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
