﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Service
{
    public interface IDiversionOperations
    {
        /// <summary>
        /// Gets the diversions.
        /// </summary>
        /// <returns>List of diversions.</returns>
        IList<Diversion> GetDiversions(II facilityId);

        /// <summary>
        /// Finds the diversion by id.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <returns></returns>
        Diversion FindDiversionById(string domain , string id, II facilityId);

        /// <summary>
        /// Saves the diversion.
        /// </summary>
        /// <param name="diversion">The diversion.</param>
        /// <param name="isAddOperation">if set to <c>true</c> [is add operation].</param>
        void SaveDiversion(Diversion diversion, bool isAddOperation, II facilityId);
    }
}
