﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    [DataContract]
    public class WaitingListReport
    {
        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>        
        [DataMember]
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        [DataMember]
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [DataMember]
        public DateTime? EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        [DataMember]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the removed date.
        /// </summary>
        /// <value>
        /// The removed date.
        /// </value>
        [DataMember]
        public DateTime? RemovedDate { get; set; }

        /// <summary>
        /// Gets or sets the waiting area.
        /// </summary>
        /// <value>
        /// The waiting area.
        /// </value>
        [DataMember]
        public string WaitingArea { get; set; }

        /// <summary>
        /// Gets or sets the last edited by.
        /// </summary>
        /// <value>
        /// The last edited by.
        /// </value>
        [DataMember]
        public string LastEditedBy { get; set; }

        /// <summary>
        /// Gets or sets the community services.
        /// </summary>
        /// <value>
        /// The community services.
        /// </value>
        [DataMember]
        public string CommunityServices { get; set; }

        /// <summary>
        /// Gets or sets the contract fee.
        /// </summary>
        /// <value>
        /// The contract fee.
        /// </value>
        [DataMember]
        public string ContractFee { get; set; }

        /// <summary>
        /// Gets or sets the reason using fee.
        /// </summary>
        /// <value>
        /// The reason using fee.
        /// </value>
        [DataMember]
        public string ReasonUsingFee { get; set; }

        /// <summary>
        /// Gets or sets the disposition fee.
        /// </summary>
        /// <value>
        /// The disposition fee.
        /// </value>
        [DataMember]
        public string DispositionFee { get; set; }

        /// <summary>
        /// Gets or sets the authorized fee.
        /// </summary>
        /// <value>
        /// The authorized fee.
        /// </value>
        [DataMember]
        public string AuthorizedFee { get; set; }

        /// <summary>
        /// Gets or sets the in house transfer.
        /// </summary>
        /// <value>
        /// The in house transfer.
        /// </value>
        [DataMember]
        public bool? InHouseTransfer { get; set; }

        /// <summary>
        /// Gets or sets the bed requested date.
        /// </summary>
        /// <value>
        /// The bed requested date.
        /// </value>
        [DataMember]
        public DateTime? BedRequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the bed assigned date.
        /// </summary>
        /// <value>
        /// The bed assigned date.
        /// </value>
        [DataMember]
        public DateTime? BedAssignedDate { get; set; }

        /// <summary>
        /// Gets or sets the fee comments.
        /// </summary>
        /// <value>
        /// The fee comments.
        /// </value>
        [DataMember]
        public string FeeComments { get; set; }

        /// <summary>
        /// Gets or sets the room bed assigned.
        /// </summary>
        /// <value>
        /// The room bed assigned.
        /// </value>
        [DataMember]
        public string RoomBedAssigned { get; set; }

        /// <summary>
        /// Gets or sets the type of bed ward.
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [DataMember]
        public string TypeOfBedWard { get; set; }

        /// <summary>
        /// Gets or sets the presenting problem.
        /// </summary>
        /// <value>
        /// The presenting problem.
        /// </value>
        [DataMember]
        public string PresentingProblem { get; set; }

        /// <summary>
        /// Gets or sets the act id.
        /// </summary>
        /// <value>
        /// The act id.
        /// </value>
        [DataMember]
        public int ActId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [DataMember]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the room bed assigned id.
        /// </summary>
        /// <value>
        /// The room bed assigned id.
        /// </value>
        [DataMember]
        public II RoomBedAssignedId { get; set; }

    }
}
