﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using InfoWorld.HL7.ITS.Extension.EIS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Division class. Stores information about division.
    /// </summary>
    [DataContract]
    public class Division : Place
    {
        #region Constructor

        public Division(Entity entity)
        {
            this._entity = entity;
        }

        public Division()
        { }

        #endregion

        #region Public Members

        /// <summary>
        /// Gets or sets the facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        /// 
        [DataMember]
        [ConvertDateTime]
        public Facility Facility { get; set; }

        /// <summary>
        /// Gets or sets the whiteboard report path.
        /// </summary>
        /// <value>
        /// The whiteboard report path.
        /// </value>
        [DataMember]
        public string WhiteboardReportPath { get; set; }

        #endregion

        #region Private Members

        private Entity _entity;

        #endregion
    }
}
