﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using InfoWorld.EVS.CTSMAPI;

namespace BMS.Facade.Data
{
    /// <summary>
    /// BedInfo class.
    /// </summary>
    public class BedInfo
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        /// <value>
        /// The bed id.
        /// </value>
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        /// <value>
        /// The admission id.
        /// </value>
        public II AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the name of the staff.
        /// </summary>
        /// <value>
        /// The name of the staff.
        /// </value>
        public string StaffName { get; set; }

        /// <summary>
        /// Gets or sets the first name of the patient.
        /// </summary>
        /// <value>
        /// The first name of the patient.
        /// </value>
        public string PatientFirstName { get; set; }

        /// <summary>
        /// Gets or sets the last name of the patient.
        /// </summary>
        /// <value>
        /// The last name of the patient.
        /// </value>
        public string PatientLastName { get; set; }

        /// <summary>
        /// Gets or sets the SSN.
        /// </summary>
        /// <value>
        /// The SSN.
        /// </value>
        public string SSN { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient treating specialty.
        /// </summary>
        /// <value>
        /// The patient treating specialty.
        /// </value>
        public CD PatientTreatingSpecialty { get; set; }

        /// <summary>
        /// Gets or sets the discharge status code.
        /// </summary>
        /// <value>
        /// The discharge status code.
        /// </value>
        public string DischargeStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the ward id.
        /// </summary>
        /// <value>
        /// The ward id.
        /// </value>
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        /// <value>
        /// The patient gender.
        /// </value>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets the display patient gender.
        /// </summary>
        public string DisplayPatientGender 
        { 
            get
            {
                if (!string.IsNullOrEmpty(PatientGender))
                    return PatientGender.Substring(0, 1);
                else
                    return string.Empty;
            }
        }

        /// <summary>
        /// Gets or sets the name of the bed.
        /// </summary>
        /// <value>
        /// The name of the bed. 
        /// </value>
        public string BedName { get; set; }

        /// <summary>
        /// Gets or sets the los admin.
        /// </summary>
        /// <value>
        /// The los admin.
        /// </value>
        public TimeSpan LosAdmin { get; set; }

        /// <summary>
        /// Gets or sets the los ward.
        /// </summary>
        /// <value>
        /// The los ward.
        /// </value>
        public TimeSpan LosWard { get; set; }

        /// <summary>
        /// Gets or sets the los DRG.
        /// </summary>
        /// <value>
        /// The los DRG.
        /// </value>
        public TimeSpan LosDrg { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the PT.
        /// </summary>
        /// <value>
        /// The PT.
        /// </value>
        public string PT { get; set; }

        /// <summary>
        /// Gets or sets the bed availability status code.
        /// </summary>
        /// <value>
        /// The bed availability status code.
        /// </value>
        public string BedAvailabilityStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the bed cleaning status code.
        /// </summary>
        /// <value>
        /// The bed cleaning status code.
        /// </value>
        public string BedCleaningStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has multiple divisions assigned.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has multiple divisions assigned; otherwise, <c>false</c>.
        /// </value>
        public bool HasMultipleDivisionsAssigned { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has multiple comments.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has multiple comments; otherwise, <c>false</c>.
        /// </value>
        public bool HasMultipleComments { get; set; }

        /// <summary>
        /// Gets or sets the name of the division.
        /// </summary>
        /// <value>
        /// The name of the division.
        /// </value>
        public string DivisionName { get; set; }

        /// <summary>
        /// Gets or sets the level of care code.
        /// </summary>
        /// <value>
        /// The level of care code.
        /// </value>
        public string LevelOfCareCode { get; set; }

        /// <summary>
        /// Gets or sets the division list.
        /// </summary>
        /// <value>
        /// The division list.
        /// </value>
        public IList<Division> DivisionList { get; set; }

        /// <summary>
        /// Gets or sets the icon flag facility ids of patient list.
        /// </summary>
        /// <value>
        /// The icon flag facility ids of patient list.
        /// </value>
        public List<int> IconFlagFacilityIdsOfPatientList { get; set; }

        /// <summary>
        /// Gets or sets the icon flag facility ids of bed list.
        /// </summary>
        /// <value>
        /// The icon flag facility ids of bed list.
        /// </value>
        public List<int> IconFlagFacilityIdsOfBedList { get; set; }

        /// <summary>
        /// Gets or sets the icon flag ids of patient list.
        /// </summary>
        /// <value>
        /// The icon flag ids of patient list.
        /// </value>
        public List<int> IconFlagIdsOfPatientList { get; set; }

        /// <summary>
        /// Gets or sets the icon flag ids of bed list.
        /// </summary>
        /// <value>
        /// The icon flag ids of bed list.
        /// </value>
        public List<int> IconFlagIdsOfBedList { get; set; }

        /// <summary>
        /// Gets or sets the waiting list patient id.
        /// </summary>
        /// <value>
        /// The waiting list patient id.
        /// </value>
        public II WaitingListPatientId { get; set; }

        /// <summary>
        /// Gets or sets the waiting list info.
        /// </summary>
        /// <value>
        /// The waiting list info.
        /// </value>
        public string WaitingListInfo { get; set; }

        /// <summary>
        /// Gets or sets the provider.
        /// </summary>
        /// <value>
        /// The provider.
        /// </value>
        public string Provider { get; set; }

        /// <summary>
        /// Gets or sets the flow id.
        /// </summary>
        /// <value>
        /// The flow id.
        /// </value>
        public Guid? FlowId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed hold.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed hold; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedHold { get; set; }

        /// <summary>
        /// Gets or sets the level of care days.
        /// </summary>
        /// <value>
        /// The level of care days.
        /// </value>
        public int LevelOfCareDays { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is evacuation patient.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is evacuation patient; otherwise, <c>false</c>.
        /// </value>
        public bool IsEvacuationPatient { get; set; }

        /// <summary>
        /// Gets or sets the evacuation disposition status.
        /// </summary>
        /// <value>
        /// The evacuation disposition status.
        /// </value>
        public string EvacuationDispositionStatus { get; set; }

        #endregion
    }
}
